<?php namespace Visiosoft\SmartaxModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\SmartaxModule\Http\Middleware\CheckInstaller;
use Visiosoft\SmartaxModule\Location\Contract\LocationRepositoryInterface;
use Visiosoft\SmartaxModule\Location\LocationRepository;
use Anomaly\Streams\Platform\Model\Smartax\SmartaxLocationEntryModel;
use Visiosoft\SmartaxModule\Location\LocationModel;
use Visiosoft\SmartaxModule\Measurement\Contract\MeasurementRepositoryInterface;
use Visiosoft\SmartaxModule\Measurement\MeasurementRepository;
use Anomaly\Streams\Platform\Model\Smartax\SmartaxMeasurementEntryModel;
use Visiosoft\SmartaxModule\Measurement\MeasurementModel;
use Visiosoft\SmartaxModule\Segmentation\Contract\SegmentationRepositoryInterface;
use Visiosoft\SmartaxModule\Segmentation\SegmentationRepository;
use Anomaly\Streams\Platform\Model\Smartax\SmartaxSegmentationEntryModel;
use Visiosoft\SmartaxModule\Segmentation\SegmentationModel;
use Visiosoft\SmartaxModule\Relation\Contract\RelationRepositoryInterface;
use Visiosoft\SmartaxModule\Relation\RelationRepository;
use Anomaly\Streams\Platform\Model\Smartax\SmartaxRelationEntryModel;
use Visiosoft\SmartaxModule\Relation\RelationModel;
use Visiosoft\SmartaxModule\Bbox\Contract\BboxRepositoryInterface;
use Visiosoft\SmartaxModule\Bbox\BboxRepository;
use Anomaly\Streams\Platform\Model\Smartax\SmartaxBboxEntryModel;
use Visiosoft\SmartaxModule\Bbox\BboxModel;
use Visiosoft\SmartaxModule\Feature\Contract\FeatureRepositoryInterface;
use Visiosoft\SmartaxModule\Feature\FeatureRepository;
use Anomaly\Streams\Platform\Model\Smartax\SmartaxFeatureEntryModel;
use Visiosoft\SmartaxModule\Feature\FeatureModel;
use Visiosoft\SmartaxModule\Point\Contract\PointRepositoryInterface;
use Visiosoft\SmartaxModule\Point\PointRepository;
use Anomaly\Streams\Platform\Model\Smartax\SmartaxPointEntryModel;
use Visiosoft\SmartaxModule\Point\PointModel;

class SmartaxModuleServiceProvider extends AddonServiceProvider
{

    protected $middleware = [
        CheckInstaller::class,
    ];

    protected $routes = [
        'admin/smartax' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\SmartaxController@dashboard',
        'admin/smartax/report' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\SmartaxController@report',
        'admin/smartax/settings' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\SmartaxController@settings',
        'admin/smartax/users' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\SmartaxController@users',
        'admin/smartax/users/create' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\SmartaxController@createUser',
        'admin/smartax/users/edit/{id}' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\SmartaxController@editUser',
//        'admin/smartax/list' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\SmartaxController@taxpayerList',
        'admin/smartax/map' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\SmartaxController@map',

        'admin/smartax/detail/{id}' => [
            'as' => 'visiosoft.module.smartax::detail',
            'uses' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\SmartaxController@detail',
        ],
        'admin/smartax/edit/{id}' => [
            'as' => 'visiosoft.module.smartax::edit',
            'uses' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\SmartaxController@edit',
        ],


        // API
        'api/smartax/geo-features/{type}' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\ApiController@geoFeatures',
        'api/smartax/features' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\ApiController@features',
        'api/smartax/detail/{id}' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\ApiController@pointDetail',
        'api/smartax/district-report' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\ApiController@getDistrictReport',
        'api/set-point/{id}' => [
            'as' => 'visiosoft.module.smartax::api.set_point',
            'middleware' => ['auth'],
            'uses' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\ApiController@editPoint',
        ],

        //SYNC Data
        'admin/smartax/sync/features' => [
            'uses' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\SyncController@syncFeaturesAdmin',
            'middleware' => [
                'auth'
            ],
        ],
        'smartax/sync/features' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\SyncController@syncFeatures',
        'smartax/sync/points' => 'Visiosoft\SmartaxModule\Http\Controller\Admin\SyncController@syncPoints',

        //Install
        'smartax/install' => 'Visiosoft\SmartaxModule\Http\Controller\InstallerController@install',

    ];

    protected $bindings = [
        SmartaxLocationEntryModel::class => LocationModel::class,
        SmartaxMeasurementEntryModel::class => MeasurementModel::class,
        SmartaxSegmentationEntryModel::class => SegmentationModel::class,
        SmartaxRelationEntryModel::class => RelationModel::class,
        SmartaxBboxEntryModel::class => BboxModel::class,
        SmartaxFeatureEntryModel::class => FeatureModel::class,
        SmartaxPointEntryModel::class => PointModel::class,
    ];

    protected $singletons = [
        LocationRepositoryInterface::class => LocationRepository::class,
        MeasurementRepositoryInterface::class => MeasurementRepository::class,
        SegmentationRepositoryInterface::class => SegmentationRepository::class,
        RelationRepositoryInterface::class => RelationRepository::class,
        BboxRepositoryInterface::class => BboxRepository::class,
        FeatureRepositoryInterface::class => FeatureRepository::class,
        PointRepositoryInterface::class => PointRepository::class,
    ];

    protected $providers = [
        \Yajra\DataTables\DataTablesServiceProvider::class,
    ];
}
