<?php namespace Visiosoft\SmartaxModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Illuminate\Support\Facades\DB;
use Visiosoft\SmartaxModule\Bbox\Contract\BboxRepositoryInterface;
use Visiosoft\SmartaxModule\Point\Contract\PointRepositoryInterface;

class PointsController extends ResourceController
{
    protected $points;
    protected $bbox;

    public function __construct(PointRepositoryInterface $pointRepository, BboxRepositoryInterface $bboxRepository)
    {
        $this->points = $pointRepository;
        $this->bbox = $bboxRepository;
        parent::__construct();
    }

    public function detail($id)
    {
        $detail = $this->points->newQuery()
            ->where('smartax_points.id', $id)
            ->leftJoin('smartax_relation', 'smartax_points.match_id', 'smartax_relation.match_id')
            ->limit(2)
            ->get();

        foreach ($detail as $index => $relation) {
            $bbox = $this->bbox->newQuery()->where('obj_id', $relation['obj_id'])->first();
            $bbox->detail = DB::table('basakpano')->where('id', $bbox->pano_id)->first();
            $detail[$index]->bbox = $bbox;
        }

        return response()->json($detail);
    }

    public function setPointApi($id)
    {
        $status = false;
        $required_fields = ['lat', 'lon', 'geom', 'area'];

        if (request()->has($required_fields) and $point = $this->points->find($id)) {
            $point->update([
                'lat' => $this->request->lat,
                'lon' => $this->request->lon,
                'geom' => $this->request->geom,
                'area' => $this->request->area,
                'status' => 2,
                'average_score' => 100
            ]);
            $status = true;
        }
        return response()->json(['status' => $status]);
    }
}
