<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleSmartaxCreateDetectedStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'detected',
        'title_column' => 'id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'x_min' => [
            'required' => true,
        ],
        'y_min' => [
            'required' => true,
        ],
        'x_max' => [
            'required' => true,
        ],
        'y_max' => [
            'required' => true,
        ],
        'category' => [
            'required' => true,
        ],
        'score' => [
            'required' => true,
        ],
        'pid' => [
            'required' => true,
        ],
        'match_id' => [
            'required' => true,
        ],
    ];

}
