/******/ (() => { // webpackBootstrap
    /******/ 	"use strict";
    /*!***************************************************************************!*\
      !*** ../demo1/src/js/pages/crud/ktdatatable/advanced/record-selection.js ***!
      \***************************************************************************/

// Class definition

    var KTDatatableRecordSelectionDemo = function() {
        // Private functions

        var options = {
            // datasource definition
            data: {
                type: 'remote',
                source: {
                    read: {
                        url: '/api/admin/smartax/points',
                        // sample custom headers
                        // headers: {'x-my-custom-header': 'some value', 'x-test-header': 'the value'},
                        map: function(raw) {
                            // sample data mapping
                            var dataSet = raw;
                            if (typeof raw.data !== 'undefined') {
                                dataSet = raw.data;
                            }

                            for (let i = 0; i < dataSet.length; i++) {
                                dataSet[i].area = Math.round(Number(dataSet[i].area)) + ' m<small class="align-top">2</small>'
                            }

                            return dataSet;
                        },
                    },
                },
                pageSize: perPageSize,
                serverPaging: true,
                serverFiltering: true,
                serverSorting: true,
            },

            // layout definition
            layout: {
                scroll: true, // enable/disable datatable scroll both horizontal and
                footer: false // display/hide footer
            },

            rows: {
                autoHide: false
            },

            // column sorting
            sortable: true,

            pagination: true,

            // columns definition
            columns: [{
                field: 'checkbox',
                title: '#',
                sortable: false,
                width: 20,
                selector: true,
                textAlign: 'center',
            }, {
                field: 'id',
                title: 'SERİ NO',
                sortable: 'desc',
                width: 100,
                type: 'number',
                selector: false,
            }, {
                field: 'DÜKKAN ADI',
                title: 'DÜKKAN ADI',
                sortable: true
            }, {
                field: 'area',
                title: 'ALAN',
            }, {
                field: 'created_at',
                title: 'TARİH',
                type: 'date',
                format: 'DD/MM/YYYY',
            }, {
                field: 'MAHALLE',
                title: 'MAHALLE',
            }, {
                field: 'KAPI NO',
                title: 'KAPI NO',
            }, {
                field: 'VERGİ TUTARI',
                title: 'VERGİ TUTARI',
            }, {
                field: 'Actions',
                title: 'Actions',
                sortable: false,
                width: 125,
                overflow: 'visible',
                textAlign: 'center',
                autoHide: false,
                template: function() {
                    return '\
                    <a href="javascript:;" class="btn btn-sm btn-clean btn-icon" title="Delete">\
                        <span class="svg-icon svg-icon-md">\
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">\
                                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">\
                                    <rect x="0" y="0" width="24" height="24"/>\
                                    <path d="M6,8 L6,20.5 C6,21.3284271 6.67157288,22 7.5,22 L16.5,22 C17.3284271,22 18,21.3284271 18,20.5 L18,8 L6,8 Z" fill="#000000" fill-rule="nonzero"/>\
                                    <path d="M14,4.5 L14,4 C14,3.44771525 13.5522847,3 13,3 L11,3 C10.4477153,3 10,3.44771525 10,4 L10,4.5 L5.5,4.5 C5.22385763,4.5 5,4.72385763 5,5 L5,5.5 C5,5.77614237 5.22385763,6 5.5,6 L18.5,6 C18.7761424,6 19,5.77614237 19,5.5 L19,5 C19,4.72385763 18.7761424,4.5 18.5,4.5 L14,4.5 Z" fill="#000000" opacity="0.3"/>\
                                </g>\
                            </svg>\
                        </span>\
                    </a>\
                ';
                },
            }],
        };

        var serverSelectorDemo = function() {
            // enable extension
            options.extensions = {
                // boolean or object (extension options)
                checkbox: true,
            };
            options.search = {
                input: $('#kt_datatable_search_query'),
                key: 'generalSearch'
            };

            var datatable = $('#list_datatable').KTDatatable(options);

            $('#kt_datatable_search_type').on('change', function() {
                datatable.search($(this).val().toLowerCase(), 'Durum');
            }).selectpicker();

            // datatable.on(
            //     'datatable-on-click-checkbox',
            //     function(e) {
            //         // datatable.checkbox() access to extension methods
            //         var ids = datatable.checkbox().getSelectedId();
            //         var count = ids.length;
            //
            //         $('#kt_datatable_selected_records_2').html(count);
            //
            //         if (count > 0) {
            //             $('#kt_datatable_group_action_form_2').collapse('show');
            //         } else {
            //             $('#kt_datatable_group_action_form_2').collapse('hide');
            //         }
            //     });

            datatable.on(
                'datatable-on-check datatable-on-uncheck',
                function(e) {
                    var checkedNodes = datatable.rows('.datatable-row-active').nodes();
                    var count = checkedNodes.length;
                    $('#kt_datatable_selected_records_2').html(count);
                    if (count > 0) {
                        $('#kt_datatable_group_action_form_2').collapse('show');
                    } else {
                        $('#kt_datatable_group_action_form_2').collapse('hide');
                    }
                });

            $('#kt_datatable_fetch_modal_2').on('show.bs.modal', function(e) {
                var ids = datatable.checkbox().getSelectedId();
                var c = document.createDocumentFragment();
                for (var i = 0; i < ids.length; i++) {
                    var li = document.createElement('li');
                    li.setAttribute('data-id', ids[i]);
                    li.innerHTML = 'Selected record ID: ' + ids[i];
                    c.appendChild(li);
                }
                $('#kt_datatable_fetch_display_2').append(c);
            }).on('hide.bs.modal', function(e) {
                $('#kt_datatable_fetch_display_2').empty();
            });

            $('#kt_reset').on('click', function(e) {
                e.preventDefault();
                $('.datatable-input').each(function() {
                    $(this).val('');
                    // datatable.column($(this).data('col-index')).search('', false, false);
                });
                datatable.reload();
            });
        };

        return {
            // public functions
            init: function() {
                serverSelectorDemo();
            },
        };
    }();

    jQuery(document).ready(function() {
        KTDatatableRecordSelectionDemo.init();
    });

    /******/ })()
;
//# sourceMappingURL=record-selection.js.map