<?php namespace Visiosoft\SmartaxModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\SmartaxModule\Point\Contract\PointRepositoryInterface;

class LocationController extends PublicController
{
    public function points(PointRepositoryInterface $pointRepository)
    {
        $page = request()->all();

        $points = $pointRepository->newQuery();

        if (isset($page['sort'])) {
            $points = $points->orderBy($page['sort']['field'], $page['sort']['sort']);
        }

        $points = $points->paginate(
            $page['pagination']['perpage'],
            ['*'],
            'page',
            $page['pagination']['page']
        );

        return [
            "meta" => [
                "page" => $points->currentPage(),
                "pages" => $points->lastPage(),
                "perpage" => $page['pagination']['perpage'],
                "total" => $points->total(),
                "sort" => "desc",
                "field" => "id"
            ],
            "data" => $points->items()
        ];
    }
}
