<?php namespace Visiosoft\SmartaxModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Anomaly\Streams\Platform\Support\Authorizer;
use Illuminate\Support\Facades\DB;
use Visiosoft\SmartaxModule\Feature\Contract\FeatureRepositoryInterface;

class SmartaxController extends AdminController
{
    protected $authorizer;

    public function __construct(Authorizer $authorizer)
    {
        $this->authorizer = $authorizer;
        parent::__construct();
    }

    public function dashboard(FeatureRepositoryInterface $featureRepository)
    {
        if (!$this->authorizer->authorize('visiosoft.module.smartax::smartax.dashbaord')) {
            abort(403);
        }

        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::addon.name');
        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::section.smartax.title');
        $this->breadcrumbs->add('Gösterge Paneli', '#');

        $total_area = $featureRepository->newQuery()
            ->select(DB::raw('SUM(area) as total'))
            ->first();

        $total_price = 70.0 * ($total_area->total);
        $total_price = number_format($total_price, 2, ',', '.');

        $total_object = $featureRepository->newQuery()
            ->count();

        $roads = DB::select("select sum(roads.km) as KM from (SELECT
                             ST_LengthSpheroid(ROADS.KM, 'SPHEROID[\"WGS 84\",6378137,298.257223563]')/1000 as km
                            FROM
                                (
                                    SELECT
                                    ST_MAKELINE(ST_SETSRID(geom,4326)) AS KM
                                    FROM
                                        (SELECT *
                                            FROM default_smartax_point
                                            WHERE ANOMALY IS FALSE
                                                AND DELETED_AT IS NULL
                                            ORDER BY CAPTURE_TIME
                                        ) AS TABLE_IMAGERY
                                    GROUP BY SEQUENCE_UUID
                                ) AS ROADS) as roads");

        $total_road = count($roads) ? floatval(number_format($roads[0]->km, '2')) : 0;

        $points = $featureRepository->newQuery()
            ->select('lat', 'lon')
            ->get();

        $map_points = array();
        foreach ($points as $point) {
            $map_points[] = [$point->lat, $point->lon];
        }

        $map_points = json_encode($map_points);

        return view('module::admin.dashboard', compact('total_road', 'total_object', 'total_price', 'map_points'));
    }

    public function report()
    {
        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::addon.name');
        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::section.smartax.title');
        $this->breadcrumbs->add('Rapor Oluştur', '#');

        return view('module::admin.report');
    }

    public function taxpayerList()
    {
        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::addon.name');
        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::section.smartax.title');
        $this->breadcrumbs->add('Tabela Listesi', '#');

        return view('module::admin.list');
    }

    public function map()
    {
        if (!$this->authorizer->authorize('visiosoft.module.smartax::smartax.map')) {
            abort(403);
        }

        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::addon.name');
        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::section.smartax.title');
        $this->breadcrumbs->add('Harita', '#');


        if (request()->view === 'vertical') {
            return view('module::admin/map-vertical');
        } else {
            return view('module::admin/map');
        }
    }

    public function detail($id)
    {
        if (!$this->authorizer->authorize('visiosoft.module.smartax::smartax.detail')) {
            abort(403);
        }

        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::addon.name');
        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::section.smartax.title');
        $this->breadcrumbs->add('Harita', '/admin/smartax/map');
        $this->breadcrumbs->add('Mükellef Detay', '#');

        $next_id = intval($id) + 1;

        return $this->view->make('module::admin/detail', compact('id', 'next_id'));
    }

    public function edit($id)
    {
        if (!$this->authorizer->authorize('visiosoft.module.smartax::smartax.edit')) {
            abort(403);
        }

        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::addon.name');
        $this->breadcrumbs->offsetUnset('visiosoft.module.smartax::section.smartax.title');

        $this->breadcrumbs->add('Harita', '/admin/smartax/map');
        $this->breadcrumbs->add('Mükellef Detay', route('visiosoft.module.smartax::detail', ['id' => $id]));
        $this->breadcrumbs->add('Mükellef Tabela Düzenle', '#');

        return $this->view->make('module::admin/edit', compact('id'));
    }
}
