<?php namespace Visiosoft\SmartaxModule\Commands;

use Illuminate\Support\Facades\DB;

class getGeoDistricts
{
    protected $filter_params;

    public function __construct($filter_params)
    {
        $this->filter_params = $filter_params;
    }

    public function handle()
    {
        $filter = $this->filter_params;
        $filter_query = "";

        if (!empty($filter['yol_id'])) {
            $filter_query = "where yol_id=" . $filter['yol_id'];
        }

        $query = "SELECT Row_to_json(fc) AS geojson
                    FROM   (SELECT 'FeatureCollection'         AS TYPE,
                                   Array_to_json(Array_agg(f)) AS FEATURES
                            FROM   (SELECT 'Feature'
                                                   AS TYPE,
                                           Json_build_object('objectid', LG.objectid, 'adi_numara',
                                           LG.adi_numara,'type','district')
                                                   AS
                                           properties,
                                           St_asgeojson(St_transform(LG.geom, 4326), 15, 0) :: json
                                                   AS GEOMETRY
                                    FROM   (SELECT objectid,
                                                   adi_numara,
                                                   geom
                                            FROM   default_basaksehir_mahalle $filter_query) AS LG) AS F) AS FC; ";

        $entries = DB::select($query);
        $entries = collect($entries);

        return $entries->first()->geojson;
    }
}