"use strict";
let reportTable;

function getSearchParameter(key) {
    let searchParams = new URLSearchParams(window.location.search);

    return searchParams.get(key)
}

function chartDistrict() {
    $.ajax({
        dataType: "json",
        url: '/api/smartax/district-report',
        async: true,
        success: function (result) {
            result.unshift(['Task', 'Hours per Day']);

            var data = google.visualization.arrayToDataTable(result);

            var options = {
                height: 350,
                chartArea: {width: 500, height: 500},
                colors: ['#fe3995', '#f6aa33', '#6e4ff5', '#2abe81', '#c7d2e7', '#593ae1'],
            };

            var chart = new google.visualization.PieChart(document.getElementById('chartDistrict'));
            chart.draw(data, options);
        }
    });
};

function reportMonthChart() {
    var element = document.getElementById("reportChartMonth");

    if (!element) {
        return;
    }

    var options = {
        series: [{
            name: 'Net Profit',
            data: [44, 55, 57, 56, 61, 58]
        }, {
            name: 'Revenue',
            data: [76, 85, 101, 98, 87, 105]
        }],
        chart: {
            type: 'bar',
            height: 350,
            toolbar: {
                show: false
            }
        },
        plotOptions: {
            bar: {
                horizontal: false,
                columnWidth: ['30%'],
                endingShape: 'rounded'
            },
        },
        legend: {
            show: false
        },
        dataLabels: {
            enabled: false
        },
        stroke: {
            show: true,
            width: 2,
            colors: ['transparent']
        },
        xaxis: {
            categories: ['Ocak', 'Şubat', 'Mart', 'Nisan', 'Mayıs', 'Haziran'],
            axisBorder: {
                show: false,
            },
            axisTicks: {
                show: false
            },
            labels: {
                style: {
                    colors: KTApp.getSettings()['colors']['gray']['gray-500'],
                    fontSize: '12px',
                    fontFamily: KTApp.getSettings()['font-family']
                }
            }
        },
        yaxis: {
            labels: {
                style: {
                    colors: KTApp.getSettings()['colors']['gray']['gray-500'],
                    fontSize: '12px',
                    fontFamily: KTApp.getSettings()['font-family']
                }
            }
        },
        fill: {
            opacity: 1
        },
        states: {
            normal: {
                filter: {
                    type: 'none',
                    value: 0
                }
            },
            hover: {
                filter: {
                    type: 'none',
                    value: 0
                }
            },
            active: {
                allowMultipleDataPointsSelection: false,
                filter: {
                    type: 'none',
                    value: 0
                }
            }
        },
        tooltip: {
            style: {
                fontSize: '12px',
                fontFamily: KTApp.getSettings()['font-family']
            },
            y: {
                formatter: function (val) {
                    return "$" + val + " thousands"
                }
            }
        },
        colors: [KTApp.getSettings()['colors']['theme']['base']['success'], KTApp.getSettings()['colors']['gray']['gray-300']],
        grid: {
            borderColor: KTApp.getSettings()['colors']['gray']['gray-200'],
            strokeDashArray: 4,
            yaxis: {
                lines: {
                    show: true
                }
            }
        }
    };

    var chart = new ApexCharts(element, options);
    chart.render();
};

let initTable = function () {
    return $('#reportTable').DataTable({
        responsive: true,

        dom: `<'row'<'col-sm-12'tr>>
			<'row'<'col-sm-12 col-md-5'p><'col-sm-12 col-md-7 dataTables_pager'li>>`,
        lengthMenu: [5, 10, 15, 25, 50],
        pageLength: 15,
        language: {
            'lengthMenu': '_MENU_',
        },
        info: false,
        searchDelay: 500,
        processing: true,
        serverSide: true,
        ajax: {
            url: '/api/smartax/features',
            type: 'GET',
            data: {
                columnsDef: [
                    'id',
                    'area',
                    'formatted_created_at',
                ],
            },
        },
        toolbar: {
            items: {
                info: true
            }
        },
        select: {
            style: "multi",
            selector: "td:first-child .checkable"
        },

        layout: {
            scroll: true, // enable/disable datatable scroll both horizontal and
            footer: false // display/hide footer
        },

        rows: {
            autoHide: false,
        },
        createdRow(row, data, dataIndex) {
            $(row).attr('data-id', data.id);
        },
        orderable: false,
        searchCols: [
            null,
            {"search": getSearchParameter('street')},
            {"search": getSearchParameter('road')},
        ],
        pagination: true,

        search: {
            input: $('#kt_datatable_search_query'),
            key: 'generalSearch'
        },

        autoWidth: false,
        columns: [
            {
                width: "70px",
                data: 'id',
                orderable: false,
            },
            {
                orderable: false,
                data: 'district_name',
            },
            {
                orderable: false,
                data: 'road_name',
            },
            {
                orderable: false,
                width: "70px",
                data: 'door_id',
            },
            {
                orderable: false,
                data: 'area',
                width: "100px",
                render: function (data, type, row) {
                    return parseFloat(data).toFixed(2) + ' m²';
                }
            },
            {
                orderable: false,
                width: "150px",
                data: 'formatted_created_at',
                sortable: false
            },
        ],
    });
};

jQuery(document).ready(function () {
    google.load('visualization', '1', {
        packages: ['corechart', 'bar', 'line']
    });

    google.setOnLoadCallback(function () {
        chartDistrict();
    });

    reportMonthChart();

    reportTable = initTable();
});