<?php namespace Visiosoft\SmartaxModule\Commands;

use GuzzleHttp\Client;
use Illuminate\Support\Facades\DB;
use Visiosoft\SmartaxModule\Bbox\Contract\BboxRepositoryInterface;
use Visiosoft\SmartaxModule\Feature\Contract\FeatureRepositoryInterface;
use Visiosoft\SmartaxModule\Location\Contract\LocationRepositoryInterface;
use Visiosoft\SmartaxModule\Measurement\Contract\MeasurementRepositoryInterface;
use Visiosoft\SmartaxModule\Point\Contract\PointRepositoryInterface;
use Visiosoft\SmartaxModule\Relation\Contract\RelationRepositoryInterface;

class SyncMapilioFeature
{
    protected $token;
    protected $project_key;
    protected $organization_key;

    public function __construct($token, $project_key, $organization_key)
    {
        $this->token = $token;
        $this->project_key = $project_key;
        $this->organization_key = $organization_key;
    }

    public function handle(
        MeasurementRepositoryInterface $measurementRepository,
        BboxRepositoryInterface $bboxRepository,
        RelationRepositoryInterface $relationRepository,
        LocationRepositoryInterface $locationRepository,
        FeatureRepositoryInterface $featureRepository
    )
    {
        $counter = 0;
        $skip = $featureRepository->newQuery()->count();

        // Get Features With CURL Service
        $features = $this->getFeatures($skip);

        // Save Features
        foreach ($features as $item) {

            $properties = $item['properties'];

            $is_feature = $featureRepository->newQuery()
                ->where('unique_id', $properties['id'])
                ->first();

            if (!$is_feature) {
                /**
                 * Save Feature
                 */
                $feature = $featureRepository->newQuery()
                    ->create([
                        'lat' => $properties['feature']['lat'],
                        'lon' => $properties['feature']['lon'],
                        'class_code' => $properties['feature']['class_code'],
                        'confidence' => $properties['feature']['confidence'],
                        'area' => $properties['feature']['area'],
                        'verification' => $properties['feature']['verification'],
                        'unique_id' => $properties['id'],
                        'sequence_uuid' => $properties['sequence_uuid'],
                    ]);

                // Geom Save (Feature)
                DB::statement("UPDATE default_smartax_feature
	                                        SET  geom=ST_GeomFromGeoJSON('" . $properties['feature']['geom'] . "')
	                                        WHERE id=" . $feature->id . ";");

                /**
                 * Save Measurement
                 */
                $measurementRepository->newQuery()
                    ->create([
                        'feature_id' => $feature->id,
                        'avg_width' => $properties['measurement']['avg_width'],
                        'avg_height' => $properties['measurement']['avg_height'],
                        'avg_area' => $properties['measurement']['avg_area'],
                        'sequence_uuid' => $properties['sequence_uuid'],
                    ]);


                /**
                 * Save BBOX
                 */

                foreach ($properties['matchedPoints'] as $matchedPoint) {

                    // Save BBOX 1
                    if (!$bbox_1 = $bboxRepository->newQuery()->where('bbox_key', $matchedPoint['properties']['objId_1'])->first()) {
                        $bbox_1 = $bboxRepository->newQuery()
                            ->create([
                                'x_min' => $matchedPoint['properties']['bbox_1'][0],
                                'y_min' => $matchedPoint['properties']['bbox_1'][1],
                                'x_max' => $matchedPoint['properties']['bbox_1'][2],
                                'y_max' => $matchedPoint['properties']['bbox_1'][3],
                                'score' => $matchedPoint['properties']['score_1'],
                                'photo_uuid' => $matchedPoint['properties']['photo_uuid_1'],
                                'bbox_key' => $matchedPoint['properties']['objId_1'],
                                'sequence_uuid' => $properties['sequence_uuid'],
                            ]);
                    }

                    // Save BBOX 2
                    if (!$bbox_2 = $bboxRepository->newQuery()->where('bbox_key', $matchedPoint['properties']['objId_2'])->first()) {
                        $bbox_2 = $bboxRepository->newQuery()
                            ->create([
                                'x_min' => $matchedPoint['properties']['bbox_2'][0],
                                'y_min' => $matchedPoint['properties']['bbox_2'][1],
                                'x_max' => $matchedPoint['properties']['bbox_2'][2],
                                'y_max' => $matchedPoint['properties']['bbox_2'][3],
                                'score' => $matchedPoint['properties']['score_2'],
                                'photo_uuid' => $matchedPoint['properties']['photo_uuid_2'],
                                'bbox_key' => $matchedPoint['properties']['objId_2'],
                                'sequence_uuid' => $properties['sequence_uuid'],
                            ]);
                    }

                    // Save Relation
                    $relation = $relationRepository->newQuery()
                        ->create([
                            'bbox_id_1' => $bbox_1->id,
                            'bbox_id_2' => $bbox_2->id,
                            'feature_id' => $feature->id,
                            'sequence_uuid' => $properties['sequence_uuid'],
                        ]);

                    // Save Location
                    $location = $locationRepository->newQuery()
                        ->create([
                            'lat' => $matchedPoint['geometry']['coordinates'][1],
                            'lon' => $matchedPoint['geometry']['coordinates'][0],
                            'score' => ($matchedPoint['properties']['score_1'] + $matchedPoint['properties']['score_2']) / 2,
                            'relation_id' => $relation->id,
                            'sequence_uuid' => $properties['sequence_uuid'],
                        ]);

                    // Geom Save (Location)
                    DB::statement("UPDATE default_smartax_location
	                                        SET  geom=ST_GeomFromGeoJSON('" . json_encode($matchedPoint['geometry']) . "')
	                                        WHERE id=" . $location->id . ";");
                }

                $counter++;
            }
        }

        return [
            'counter' => $counter
        ];
    }

    public function getFeatures($skip)
    {
        $features = $this->newRequest($this->token, $this->organization_key, $this->project_key, $skip);

        if (isset($features['data']['features']) && count($features['data']['features'])) {
            return $features['data']['features'];
        }

        return [];
    }

    public function newRequest($token, $organization_key, $project_key, $skip = 0)
    {
        try {
            $url = setting_value('visiosoft.module.smartax::mapilio_sync_url') . "/api/features/list" . '?' . http_build_query([
                    'token' => $token,
                    'organization_key' => $organization_key,
                    'project_key' => $project_key,
                    'skip' => $skip
                ]);

            $client = new Client([
                'cookies' => true,
                'http_errors' => false,
                'verify' => false
            ]);

            $response = $client->request('GET', $url);

            $response = $response->getBody()->getContents();

            $response = json_decode($response, true);

            if (!$response['status']) {
                throw new \Exception([$response['message']]);
            }

            return $response['response'];

        } catch (\Exception $exception) {
            throw new \Exception(["The incoming data is not correct."]);
            die;
        }
    }
}