<?php namespace Visiosoft\SmartaxModule;

use Anomaly\FilesModule\Disk\Contract\DiskRepositoryInterface;
use Anomaly\FilesModule\Folder\Contract\FolderRepositoryInterface;
use Anomaly\NavigationModule\Link\Contract\LinkRepositoryInterface;
use Anomaly\NavigationModule\Menu\Contract\MenuRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Anomaly\UrlLinkTypeExtension\UrlLinkTypeModel;
use Anomaly\UsersModule\Role\Contract\RoleRepositoryInterface;

class SmartaxModuleSeeder extends Seeder
{
    public function run(StreamRepositoryInterface $streamRepository,
                        FieldRepositoryInterface $fieldRepository,
                        MenuRepositoryInterface $menus,
                        AssignmentRepositoryInterface $assignmentRepository,
                        DiskRepositoryInterface $disks,
                        LinkRepositoryInterface $links,
                        RoleRepositoryInterface $roleRepository,
                        FolderRepositoryInterface $folders)
    {
        //Create Profile Photos Folder
        if (!$folders->findBySlug('profile_photos')) {
            $disk = $disks->findBySlug('local');

            $folders->create([
                'en' => [
                    'name' => 'Profile Photos',
                    'description' => 'A folder for Profile Photos.',
                ],
                'slug' => 'profile_photos',
                'disk' => $disk
            ]);
        };

        if ($folder = $folders->findBySlug('profile_photos')) {
            $folder->update([
                'allowed_types' => [
                    'jpg', 'jpeg', 'png'
                ],
            ]);
        }
        //Create Profile Photo Fields
        $namespace = 'users';
        $locked = 0;
        $stream = $streamRepository->findBySlugAndNamespace('users', 'users');

        $fields = [
            [
                'name' => 'Profile Photo',
                'slug' => 'profile_photo',
                'type' => 'anomaly.field_type.file',
                'config' => [
                    'folders' => ["profile_photos"],
                    'mode' => 'upload',
                ]
            ]
        ];

        foreach ($fields as $customField) {
            if (!$field = $fieldRepository->findBySlugAndNamespace($customField['slug'], $namespace)) {
                $data = [
                    'name' => $customField['name'],
                    'namespace' => $namespace,
                    'slug' => $customField['slug'],
                    'type' => $customField['type'],
                    'locked' => $locked
                ];
                if (isset($customField['config'])) {
                    $data['config'] = $customField['config'];
                }

                $field = $fieldRepository->create($data);

                $assignmentRepository->create([
                    'stream_id' => $stream->getId(),
                    'field_id' => $field->getId()
                ]);
            }
        }


        //Left Menu
        $menu = array();
        if (!$menu['left_menu'] = $menus->findBySlug('left_menu')) {
            $menu['left_menu'] = $menus->create(
                [
                    'en' => [
                        'name' => 'Left Menu',
                        'description' => 'Left Menu',
                    ],
                    'tr' => [
                        'name' => 'Sol Menu',
                        'description' => 'Sol Menü',
                    ],
                    'slug' => 'left_menu',
                ]
            );
        }

        //Left Top Menu
        if (!$menu['left_top_menu'] = $menus->findBySlug('left_top_menu')) {
            $menu['left_top_menu'] = $menus->create(
                [
                    'en' => [
                        'name' => 'Left Top Menu',
                        'description' => 'Left Top Menu',
                    ],
                    'tr' => [
                        'name' => 'Sol Üst Menu',
                        'description' => 'Sol Üst Menü',
                    ],
                    'slug' => 'left_top_menu',
                ]
            );
        }


        //Menu Links
        $url = new EntryRepository();
        $url->setModel(new UrlLinkTypeModel());

        $main_menu = [
            [
                'title' => 'Raporlar',
                'url' => '#',
                'class' => 'theme::images/navigations/raporlar.svg',
                'menu' => 'left_menu',
            ],
            [
                'title' => 'Mükellefler',
                'url' => '#',
                'class' => 'theme::images/navigations/mukellefler.svg',
                'menu' => 'left_menu',
                'child' => [
                    [
                        'title' => 'Mükellef Ekle',
                        'url' => '#',
                    ], [
                        'title' => 'Mükellef Listele',
                        'url' => '#',
                    ], [
                        'title' => 'M. Adres Ekle',
                        'url' => '#',
                    ], [
                        'title' => 'M. Adres Listele',
                        'url' => '#',
                    ]
                ]
            ],
            [
                'title' => 'Vergi Oranları',
                'url' => '#',
                'class' => 'theme::images/navigations/vergi_oranlari.svg',
                'menu' => 'left_menu',
            ],
            [
                'title' => 'İptal Talepleri',
                'url' => '#',
                'class' => 'theme::images/navigations/iptal_talepleri.svg',
                'menu' => 'left_menu',
            ],
            [
                'title' => 'Gösterge Paneli',
                'url' => 'admin/smartax',
                'class' => 'theme::images/navigations/gosterge_paneli.svg',
                'menu' => 'left_top_menu',
            ],
        ];

        $links->truncate();
        $url->truncate();

        foreach ($main_menu as $menu_item) {
            $url_entry = $url->create(
                [
                    'en' => [
                        'title' => $menu_item['title'],
                    ],
                    'url' => $menu_item['url'],
                ]
            );

            $link = $links->create(
                [
                    'menu' => $menu[$menu_item['menu']],
                    'target' => '_blank',
                    'class' => $menu_item['class'],
                    'entry' => $url_entry,
                    'type' => 'anomaly.extension.url_link_type',
                ]
            );

            if (isset($menu_item['roles'])) {
                $link->allowedRoles()->sync($menu_item['roles']);
            }

            if (isset($menu_item['child'])) {
                $parent_menu = $menu[$menu_item['menu']];

                foreach ($menu_item['child'] as $child_menu) {
                    $url_entry_child = $url->create(
                        [
                            'en' => [
                                'title' => $child_menu['title'],
                            ],
                            'url' => $child_menu['url'],
                        ]
                    );

                    $links->create(
                        [
                            'menu' => $parent_menu,
                            'target' => '_blank',
                            'parent_id' => $link->getId(),
                            'entry' => $url_entry_child,
                            'type' => 'anomaly.extension.url_link_type',
                        ]
                    );
                }
            }

        }

        // Create Role
        $role_entries = [
            [
                'slug' => 'smartax_admin2',
                'name' => 'Smartax Admin',
                'description' => 'The Smartax Admin Role',
                'permissions' => 'a:5:{i:1;s:29:"streams::control_panel.access";i:34;s:44:"visiosoft.module.smartax::smarttax.dashbaord";i:35;s:43:"visiosoft.module.smartax::smarttax.location";i:36;s:41:"visiosoft.module.smartax::smarttax.detail";i:37;s:39:"visiosoft.module.smartax::smarttax.edit";}'
            ]
        ];

        foreach ($role_entries as $role) {

            if (!$roleRepository->findBySlug($role['slug'])) {

                $roleRepository->create(
                    [
                        config('app.locale', 'en') => [
                            'name' => $role['name'],
                            'description' => $role['description'],
                        ],
                        'permissions' => $role['permissions'],
                        'slug' => $role['slug'],
                    ]
                );

            }

        }
    }
}
