<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Illuminate\Support\Facades\DB;

class VisiosoftModuleSmartaxCreateLocationStream extends Migration
{
    protected $delete = true;

    protected $stream = [
        'slug' => 'location',
        'title_column' => 'id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => true,
        'sortable' => false,
    ];

    protected $fields = [
        'lat' => 'anomaly.field_type.decimal',
        'lon' => 'anomaly.field_type.decimal',
        'geom' => 'anomaly.field_type.textarea', // Geometry('POINT')
        'score' => 'anomaly.field_type.decimal',
        'relation_id' => 'anomaly.field_type.integer',
        'sequence_uuid' => 'anomaly.field_type.text',
    ];

    protected $assignments = [
        'lat',
        'lon',
        'geom',
        'score',
        'relation_id',
        'sequence_uuid',
    ];

    public function up()
    {
        if (env('DB_CONNECTION') == "pgsql") {
            DB::statement("ALTER TABLE default_smartax_location ALTER COLUMN geom type geometry(Point);");
        }
    }
}
