<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Illuminate\Support\Facades\DB;

class VisiosoftModuleSmartaxCreateFeatureStream extends Migration
{
    protected $delete = false;

    protected $stream = [
        'slug' => 'feature',
        'title_column' => 'id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => true,
        'sortable' => false,
    ];

    protected $fields = [
        'lat' => 'anomaly.field_type.decimal',
        'lon' => 'anomaly.field_type.decimal',
        'geom' => 'anomaly.field_type.textarea', // Geometry('POINT')
        'class_code' => 'anomaly.field_type.text',
        'confidence' => 'anomaly.field_type.decimal',
        'area' => 'anomaly.field_type.decimal',
        'verification' => 'anomaly.field_type.boolean',
        'sequence_uuid' => 'anomaly.field_type.text',
        'unique_id' => 'anomaly.field_type.integer',
    ];

    protected $assignments = [
        'lat',
        'lon',
        'geom',
        'class_code',
        'confidence',
        'area',
        'verification',
        'sequence_uuid',
        'unique_id'
    ];

    public function up()
    {
        if (env('DB_CONNECTION') == "pgsql") {
            DB::statement("ALTER TABLE default_smartax_feature ALTER COLUMN geom type geometry(Point);");
        }
    }
}
