<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Illuminate\Support\Facades\DB;

class VisiosoftModuleSmartaxCreatePointStream extends Migration
{
    protected $delete = false;

    protected $stream = [
        'slug' => 'point',
        'title_column' => 'id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => true,
        'sortable' => false,
    ];

    protected $fields = [
        'lat' => 'anomaly.field_type.decimal',
        'lon' => 'anomaly.field_type.decimal',
        'geom' => 'anomaly.field_type.textarea', // Geometry('POINT')
        'heading' => 'anomaly.field_type.decimal',
        'altitude' => 'anomaly.field_type.decimal',
        'orientation' => 'anomaly.field_type.integer',
        'capture_time' => 'anomaly.field_type.datetime',
        'uploaded_hash' => 'anomaly.field_type.text',
        'filename' => 'anomaly.field_type.text',
        'device_make' => 'anomaly.field_type.text',
        'device_model' => 'anomaly.field_type.text',
        'sequence_uuid' => 'anomaly.field_type.text',
        'photo_uuid' => 'anomaly.field_type.textarea',
        'resolution' => 'anomaly.field_type.text',
        'fov' => 'anomaly.field_type.decimal',
        'anomaly' => [
            'type' => 'anomaly.field_type.boolean',
            'config' => [
                'default_value' => false
            ],
        ],
        'data_created_by_id' => 'anomaly.field_type.integer',
    ];

    protected $assignments = [
        'lat',
        'lon',
        'geom',
        'heading',
        'altitude',
        'orientation',
        'filename',
        'device_make',
        'device_model',
        'sequence_uuid',
        'uploaded_hash',
        'photo_uuid',
        'resolution',
        'fov',
        'anomaly',
        'data_created_by_id',
        'capture_time',
    ];

    public function up()
    {
        if (env('DB_CONNECTION') == "pgsql") {
            DB::statement("ALTER TABLE default_smartax_point ALTER COLUMN geom type geometry(Point);");
            DB::statement("ALTER TABLE default_smartax_point ALTER COLUMN uploaded_hash TYPE VARCHAR (500)");
        }
    }
}
