$(function () {

    // Detect ajax errors.
    $(document).ajaxError(function (event, xhr) {

        // Close all modals.
        $('.modal').modal('hide');

        errorS();

        if (xhr.status === 401) {
            if (window.location.pathname.startsWith('/admin')) {
                window.location = APPLICATION_URL + '/admin/login';
            } else {
                window.location = APPLICATION_URL + '/login';
            }
        }
    });
});

function errorS() {
    Swal.fire({
        allowOutsideClick: false,
        title: 'Hay Aksi!',
        text: "Bir hata oluştu.",
        icon: 'error',
        showCancelButton: false,
        confirmButtonColor: '#3085d6',
        confirmButtonText: 'Tekrar Dene'
    }).then((result) => {
        if (result.isConfirmed) {
            location.reload();
        }
    })
}
