<?php namespace Visiosoft\SmartTaxTheme;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Ui\ControlPanel\Component\Navigation\Event\SortNavigation;
use Anomaly\Streams\Platform\Ui\Table\Event\TableIsQuerying;
use Illuminate\Pagination\AbstractPaginator;
use Visiosoft\SmartTaxTheme\Listener\AddGsmFilter;
use Visiosoft\SmartTaxTheme\Listener\AddViewAdsButton;
use Visiosoft\SmartTaxTheme\Listener\ApplySorting;

/**
 * Class SmartTaxThemeThemeServiceProvider
 *
 * @link   http://openclassify.com/
 * @author OpenClassify, Inc. <support@openclassify.com>
 * @author Vedat Akdogan <vedat@openclassify.com>
 */
class SmartTaxThemeServiceProvider extends AddonServiceProvider
{
    protected $listeners = [
        SortNavigation::class => [
            ApplySorting::class,
        ],
        TableIsQuerying::class => [
            AddGsmFilter::class,
            AddViewAdsButton::class
        ],
    ];

    public function register()
    {
        AbstractPaginator::$defaultView       = 'visiosoft.theme.smart_tax::pagination/bootstrap-4';
        AbstractPaginator::$defaultSimpleView = 'streams::pagination/simple-bootstrap-4';
    }

    protected $overrides = [
        'streams::table/table' => 'visiosoft.theme.smart_tax::table/table',
        'streams::table/ajax' => 'visiosoft.theme.smart_tax::addons/anomaly/streams-platform/table/ajax',
        'streams::table/partials/filters' => 'visiosoft.theme.smart_tax::table/partials/filters',
        'streams::table/partials/header' => 'visiosoft.theme.smart_tax::table/partials/header',
        'streams::table/partials/views' => 'visiosoft.theme.smart_tax::table/partials/views',
        'streams::table/partials/body' => 'visiosoft.theme.smart_tax::table/partials/body',
        'streams::form/partials/tabs' => 'visiosoft.theme.smart_tax::form/partials/tabs',
        'streams::form/partials/controls' => 'visiosoft.theme.smart_tax::form/partials/controls',

        // File field type
        'anomaly.field_type.file::upload/index' => 'visiosoft.theme.smart_tax::addons/anomaly/file-field_type/upload/index',
        'anomaly.field_type.file::input' => 'visiosoft.theme.smart_tax::addons/anomaly/file-field_type/input',

        // Multiple field type
        'anomaly.field_type.multiple::lookup' => 'visiosoft.theme.smart_tax::addons/anomaly/multiple-field_type/lookup',
    ];
}
