<?php namespace Visiosoft\SmartTaxTheme;

use Anomaly\FilesModule\Disk\Contract\DiskRepositoryInterface;
use Anomaly\FilesModule\Folder\Contract\FolderRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;

class SmartTaxThemeSeeder extends Seeder
{
    public function run(StreamRepositoryInterface $streamRepository,
                        FieldRepositoryInterface $fieldRepository,
                        AssignmentRepositoryInterface $assignmentRepository,
                        DiskRepositoryInterface $disks,
                        FolderRepositoryInterface $folders)
    {
        //Create Profile Photos Folder
        if (!$folders->findBySlug('profile_photos')) {
            $disk = $disks->findBySlug('local');

            $folders->create([
                'en' => [
                    'name' => 'Profile Photos',
                    'description' => 'A folder for Profile Photos.',
                ],
                'slug' => 'profile_photos',
                'disk' => $disk
            ]);
        };

        if ($folder = $folders->findBySlug('profile_photos')) {
            $folder->update([
                'allowed_types' => [
                    'jpg', 'jpeg', 'png'
                ],
            ]);
        }
        //Create Profile Photo Fields
        $namespace = 'users';
        $locked = 0;
        $stream = $streamRepository->findBySlugAndNamespace('users', 'users');

        $fields = [
            [
                'name' => 'Profile Photo',
                'slug' => 'profile_photo',
                'type' => 'anomaly.field_type.file',
                'config' => [
                    'folders' => ["profile_photos"],
                    'mode' => 'upload',
                ]
            ]
        ];

        foreach ($fields as $customField) {
            if (!$field = $fieldRepository->findBySlugAndNamespace($customField['slug'], $namespace)) {
                $data = [
                    'name' => $customField['name'],
                    'namespace' => $namespace,
                    'slug' => $customField['slug'],
                    'type' => $customField['type'],
                    'locked' => $locked
                ];
                if (isset($customField['config'])) {
                    $data['config'] = $customField['config'];
                }

                $field = $fieldRepository->create($data);

                $assignmentRepository->create([
                    'stream_id' => $stream->getId(),
                    'field_id' => $field->getId()
                ]);
            }
        }
    }
}
