<?php namespace Visiosoft\SmartTaxTheme;

use Anomaly\FilesModule\Disk\Contract\DiskRepositoryInterface;
use Anomaly\FilesModule\Folder\Contract\FolderRepositoryInterface;
use Anomaly\NavigationModule\Link\Contract\LinkRepositoryInterface;
use Anomaly\NavigationModule\Menu\Contract\MenuRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Anomaly\UrlLinkTypeExtension\UrlLinkTypeModel;

class SmartTaxThemeSeeder extends Seeder
{
    public function run(StreamRepositoryInterface $streamRepository,
                        FieldRepositoryInterface $fieldRepository,
                        MenuRepositoryInterface $menus,
                        AssignmentRepositoryInterface $assignmentRepository,
                        DiskRepositoryInterface $disks,
                        LinkRepositoryInterface $links,
                        FolderRepositoryInterface $folders)
    {
        //Create Profile Photos Folder
        if (!$folders->findBySlug('profile_photos')) {
            $disk = $disks->findBySlug('local');

            $folders->create([
                'en' => [
                    'name' => 'Profile Photos',
                    'description' => 'A folder for Profile Photos.',
                ],
                'slug' => 'profile_photos',
                'disk' => $disk
            ]);
        };

        if ($folder = $folders->findBySlug('profile_photos')) {
            $folder->update([
                'allowed_types' => [
                    'jpg', 'jpeg', 'png'
                ],
            ]);
        }
        //Create Profile Photo Fields
        $namespace = 'users';
        $locked = 0;
        $stream = $streamRepository->findBySlugAndNamespace('users', 'users');

        $fields = [
            [
                'name' => 'Profile Photo',
                'slug' => 'profile_photo',
                'type' => 'anomaly.field_type.file',
                'config' => [
                    'folders' => ["profile_photos"],
                    'mode' => 'upload',
                ]
            ]
        ];

        foreach ($fields as $customField) {
            if (!$field = $fieldRepository->findBySlugAndNamespace($customField['slug'], $namespace)) {
                $data = [
                    'name' => $customField['name'],
                    'namespace' => $namespace,
                    'slug' => $customField['slug'],
                    'type' => $customField['type'],
                    'locked' => $locked
                ];
                if (isset($customField['config'])) {
                    $data['config'] = $customField['config'];
                }

                $field = $fieldRepository->create($data);

                $assignmentRepository->create([
                    'stream_id' => $stream->getId(),
                    'field_id' => $field->getId()
                ]);
            }
        }


        //Left Menu
        if (!$menu = $menus->findBySlug('left_menu')) {
            $menu = $menus->create(
                [
                    'en' => [
                        'name' => 'Left Menu',
                        'description' => 'Left Menu',
                    ],
                    'tr' => [
                        'name' => 'Sol Menu',
                        'description' => 'Sol Menü',
                    ],
                    'slug' => 'left_menu',
                ]
            );
        }


        //Menu Links
        $url = new EntryRepository();
        $url->setModel(new UrlLinkTypeModel());

        $main_menu = [
            [
                'title' => 'Raporlar',
                'url' => 'admin/smartax/report'
            ],
            [
                'title' => 'Liste',
                'url' => 'admin/smartax/list'
            ],
            [
                'title' => 'Mükellefler',
                'url' => 'smartax/mukellefler',
                'child' => [
                    [
                        'title' => 'Mükellef Ekle',
                        'url' => 'smartax/mukellefler/ekle',
                    ], [
                        'title' => 'Mükellef Listele',
                        'url' => 'smartax/mukellefler/listele',
                    ], [
                        'title' => 'M. Adres Ekle',
                        'url' => 'smartax/mukellefler/adres-ekle',
                    ], [
                        'title' => 'M. Adres Listele',
                        'url' => 'smartax/mukellefler/adres-listele',
                    ]
                ]
            ],
            [
                'title' => 'Vergi Oranları',
                'url' => 'smartax/mukellefler'
            ]
        ];

        foreach ($main_menu as $menu_item) {
            $url_entry = $url->create(
                [
                    'en' => [
                        'title' => $menu_item['title'],
                    ],
                    'url' => $menu_item['url'],
                ]
            );

            $link = $links->create(
                [
                    'menu' => $menu,
                    'target' => '_blank',
                    'entry' => $url_entry,
                    'type' => 'anomaly.extension.url_link_type',
                ]
            );

            if (isset($menu_item['child'])) {
                foreach ($menu_item['child'] as $child_menu) {
                    $url_entry_child = $url->create(
                        [
                            'en' => [
                                'title' => $child_menu['title'],
                            ],
                            'url' => $child_menu['url'],
                        ]
                    );

                    $links->create(
                        [
                            'menu' => $menu,
                            'target' => '_blank',
                            'parent_id' => $link->getId(),
                            'entry' => $url_entry_child,
                            'type' => 'anomaly.extension.url_link_type',
                        ]
                    );
                }
            }

        }
    }
}
