<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleSliderCreateSlidersStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'sliders',
        'title_column' => 'header',
        'translatable' => true,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'image' => [
            'required' => true,
        ],
        'header' => [
            'translatable' => true,
        ],
        'subtext' => [
            'translatable' => true,
        ],
        'url',
    ];

}
