<?php namespace Visiosoft\SitemapExtension\Http\Controller;

use Anomaly\PagesModule\Page\PageRepository;
use Anomaly\PostsModule\Post\PostRepository;
use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\LocationModule\City\Contract\CityRepositoryInterface;

class SitemapController extends PublicController
{

    private $categoryRepository;
    private $cityRepository;
    private $postRepository;
    private $pageRepository;

    public function __construct(
        CategoryRepositoryInterface $categoryRepository,
        CityRepositoryInterface     $cityRepository,
        PostRepository              $postRepository,
        PageRepository              $pageRepository
    )
    {
        parent::__construct();
        $this->categoryRepository = $categoryRepository;
        $this->cityRepository = $cityRepository;
        $this->postRepository = $postRepository;
        $this->pageRepository = $pageRepository;
    }

    public function index()
    {
        $categoriesCount = $this->categoryRepository->newQuery()->where('deleted_at' ,'=', NULL)->count();
        $postCount = $this->postRepository->newQuery()->where('enabled','!=', 0)->count();
        $pagesCount = $this->pageRepository->newQuery()->where('enabled','!=', 0)->count();

        if (setting_value('visiosoft.extension.sitemap::include_cities_sitemap')) {
            $citiesCount = $this->cityRepository->count();
            $categoryCount = $citiesCount ? $categoriesCount * $citiesCount : $categoriesCount;
        } else {
            $categoryCount = $categoriesCount;
        }

        $categoryCount = ceil($categoryCount / setting_value('visiosoft.extension.sitemap::sitemap_dividing_number'));
        $postCount = ceil($postCount / setting_value('visiosoft.extension.sitemap::sitemap_dividing_number'));
        $pagesCount = ceil($pagesCount / setting_value('visiosoft.extension.sitemap::sitemap_dividing_number'));
        return response()->view('visiosoft.extension.sitemap::sitemap.index', [
            'categoryCount' => $categoryCount,
            'postCount' => $postCount,
            'pagesCount' => $pagesCount,
        ])->header('Content-Type', 'text/xml');
    }

    public function categories()
    {
        $sitemapDividingNumber = setting_value('visiosoft.extension.sitemap::sitemap_dividing_number');
        $page = request()->page ?: 1;
        $skip = $page - 1;

        if (setting_value('visiosoft.extension.sitemap::include_cities_sitemap')
            && $citiesCount = $this->cityRepository->count()) {
            $categoriesCount = $this->categoryRepository->count();

            $takeCategories = $categoriesCount / ($categoriesCount * $citiesCount / $sitemapDividingNumber);

            $categories = $this->categoryRepository
                ->newQuery()
                ->where('deleted_at' ,'=', NULL)
                ->skip($takeCategories * $skip)
                ->take($takeCategories)
                ->get();

            $sitemapLinks = array();
            $cities = $this->cityRepository->all();

            foreach ($categories as $category) {
                foreach ($cities as $city) {
                    $sitemapLinks[] = route('adv_list_seo', [$category->slug, $city->slug]);
                }
            }
        } else {
            $categories = $this->categoryRepository
                ->newQuery()
                ->where('deleted_at' ,'=', NULL)
                ->skip($sitemapDividingNumber * $skip)
                ->take($sitemapDividingNumber)
                ->get();

            $sitemapLinks = array();
            foreach ($categories as $category) {
                $sitemapLinks[] = route('adv_list_seo', [$category->slug]);
            }
        }

        return response()->view('visiosoft.extension.sitemap::sitemap.categories', [
            'sitemapLinks' => $sitemapLinks,
        ])->header('Content-Type', 'text/xml');
    }

    public function posts()
    {
        $sitemapDividingNumber = setting_value('visiosoft.extension.sitemap::sitemap_dividing_number');
        $page = request()->page ?: 1;
        $skip = $page - 1;


        $posts = $this->postRepository
            ->newQuery()
            ->where('enabled','!=',0)
            ->skip($sitemapDividingNumber * $skip)
            ->take($sitemapDividingNumber)
            ->get();

        $sitemapLinks = array();
        foreach ($posts as $post) {
            $sitemapLinks[] = $post->route('view');
        }

        return response()->view('visiosoft.extension.sitemap::sitemap.posts', [
            'sitemapLinks' => $sitemapLinks,
        ])->header('Content-Type', 'text/xml');
    }

    public function pages()
    {
        $sitemapDividingNumber = setting_value('visiosoft.extension.sitemap::sitemap_dividing_number');
        $page = request()->page ?: 1;
        $skip = $page - 1;


        $pages = $this->pageRepository
            ->newQuery()
            ->where('enabled','!=',0)
            ->skip($sitemapDividingNumber * $skip)
            ->take($sitemapDividingNumber)
            ->get();

        $sitemapLinks = array();
        foreach ($pages as $page) {
            $sitemapLinks[] = url('/').$page->route('view');
        }

        return response()->view('visiosoft.extension.sitemap::sitemap.posts', [
            'sitemapLinks' => $sitemapLinks,
        ])->header('Content-Type', 'text/xml');
    }


}
