<?php namespace Visiosoft\SiteWidgetExtension;
use Anomaly\DashboardModule\Dashboard\Contract\DashboardRepositoryInterface;
use Anomaly\DashboardModule\Widget\Contract\WidgetRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Model\Dashboard\DashboardWidgetsEntryTranslationsModel;
class SiteWidgetExtensionSeeder extends Seeder
{

    /**
     * Run the seeder.
     */
    public function run(
        WidgetRepositoryInterface $widgetRepository,
        DashboardRepositoryInterface $dashboardRepository,
        DashboardWidgetsEntryTranslationsModel $widgetsEntryTranslationsModel
    )
    {
        $siteWidget = $widgetRepository->findBy('extension', 'visiosoft.extension.site_widget');
        if ($siteWidget) {
            $widgetsEntryTranslationsModel->newQuery()->where('entry_id', $siteWidget->id)->delete();
            $siteWidget->forceDelete();
        }

        $dashboard = $dashboardRepository->findBy('slug', 'welcome');
        if (is_null($dashboard)) {
            $dashboard = $dashboardRepository->create([
                'name' => 'Welcome',
                'slug' => 'welcome',
                'description' => 'This is the default dashboard.',
                'layout'      => '24'
            ]);
        }

        $widgetRepository->create([
            'title' => 'Site',
            'extension'   => 'visiosoft.extension.site_widget',
            'dashboard'   => $dashboard->id,
            'pinned'   => true,
        ]);
    }
}