<?php namespace Visiosoft\SiteWidgetExtension\Command;

use Anomaly\DashboardModule\Widget\Contract\WidgetInterface;
use GuzzleHttp\Client;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Visiosoft\SiteWidgetExtension\Http\Service\SiteApiService;


class LoadItems
{

    use DispatchesJobs;

    protected $widget, $siteAPIService;

    public function __construct(WidgetInterface $widget)
    {
        $this->widget = $widget;
        $this->siteAPIService = app(SiteApiService::class);
    }

    public function handle()
    {
        $this->widget->addData('detail', $this->siteAPIService->getSiteDetails());
        $this->widget->addData('plans', $this->siteAPIService->getSitePlans());
        $this->widget->addData('domains', $this->siteAPIService->getDomainsList());
    }
}
