<?php namespace Visiosoft\SiteWidgetExtension\Command;

use Anomaly\DashboardModule\Widget\Contract\WidgetInterface;
use GuzzleHttp\Client;
use Illuminate\Foundation\Bus\DispatchesJobs;


class LoadItems
{

    use DispatchesJobs;

    protected $widget;

    public function __construct(WidgetInterface $widget)
    {
        $this->widget = $widget;
    }

    public function handle()
    {
        $this->widget->addData('detail', $this->getSiteDetails());
        $this->widget->addData('plans', $this->getSitePlans());
    }

    protected function getSitePlans()
    {
        try {
            $results = $this->getRequest(setting_value('visiosoft.extension.site_widget::site_plans_api'));
            return $results['data'];
        } catch (\Exception $e) {
            return [];
        }
    }

    protected function getSiteDetails()
    {
        try {
            $params = [
                'token' => setting_value('visiosoft.extension.site_widget::site_service_token'),
                'subdomain' => setting_value('visiosoft.extension.site_widget::site_service_subdomain'),
            ];
            $results = $this->getRequest(setting_value('visiosoft.extension.site_widget::site_detail_api'), $params);
            $detail = $results['data'][0];
            $data = [];
            $startedAt = strtotime($detail['created_at']);
            $endedAt = strtotime($detail['created_at']) + $detail['remaining_day'] * 86400;
            $data['remaining_day'] = $detail['remaining_day'] - (int)round((time() - $startedAt) / 86400);
            $data['started_at'] = date('d M Y', $startedAt);
            $data['ended_at'] = date('d M Y', $endedAt);
            $percent = round((((time() - $startedAt) / ($endedAt - $startedAt))) * 100);
            $data['percentage'] = $percent . '%';
            $data['plan_name'] = $detail['plan_name'];
            if ($percent > 100) {
                $data['percentage'] = '100%';
            }
            if ($percent < 0) {
                $data['percentage'] = '0';
            }
            if ($data['remaining_day'] < 0) {
                $data['remaining_day'] = 0;
            }
            return $data;
        } catch (\Exception $e) {
            return [];
        }
    }

    protected function getRequest($url, $params = [])
    {
        $client = new Client();
        $queryString = http_build_query($params);
        $response = $client->request('get', $url . '?' . $queryString);
        return json_decode($response->getBody(), true);
    }
}
