<?php namespace Visiosoft\SiteWidgetExtension\Http\Service;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use GuzzleHttp\Client;
use Illuminate\Http\Request;

class SiteApiService
{
    protected $params, $request, $settingRepository;

    public function __construct(Request $request, SettingRepositoryInterface $settingRepository)
    {
        $this->request = $request;
        $this->settingRepository = $settingRepository;
        $this->params = [
            'token' => env('AUTO_TOKEN'),
            'subdomain' => setting_value('visiosoft.extension.site_widget::site_service_subdomain')
        ];
        if (empty(setting_value('visiosoft.extension.site_widget::site_service_subdomain'))) {
            $this->getSiteDetails();
            $this->params['subdomain'] = setting_value('visiosoft.extension.site_widget::site_service_subdomain');
        }
    }

    public function getDomainsList()
    {
        try {
            $params = $this->params;
            $results = $this->request('GET', setting_value('visiosoft.extension.site_widget::site_domain_list_api'), [], $params);
            return $results['data'];
        } catch (\Exception $e) {
            return [];
        }
    }

    public function getSitePlans()
    {
        try {
            $results = $this->request('GET', setting_value('visiosoft.extension.site_widget::site_plans_api'), [], []);
            return $results['data'];
        } catch (\Exception $e) {
            return [];
        }
    }

    public function getSiteDetails()
    {
        try {
            $params = $this->params;
            $results = $this->request('GET', setting_value('visiosoft.extension.site_widget::site_detail_api'), [], $params);
            $detail = $results['data'][0];
            $data = [];
            $startedAt = strtotime($detail['created_at']);
            $endedAt = strtotime($detail['created_at']) + $detail['remaining_day'] * 86400;
            $data['remaining_day'] = $detail['remaining_day'] - (int)round((time() - $startedAt) / 86400);
            $data['started_at'] = date('d m Y', $startedAt);
            $data['ended_at'] = date('d m Y', $endedAt);
            $percent = round((((time() - $startedAt) / ($endedAt - $startedAt))) * 100);
            $data['percentage'] = $percent . '%';
            $data['plan_name'] = $detail['plan_name'];
            if ($percent > 100) {
                $data['percentage'] = '100%';
            }
            if ($percent < 0) {
                $data['percentage'] = '0';
            }
            if ($data['remaining_day'] < 0) {
                $data['remaining_day'] = 0;
            }
            if (empty(setting_value('visiosoft.extension.site_widget::site_service_subdomain'))) {
                $this->settingRepository->set('visiosoft.extension.site_widget::site_service_subdomain', $detail['subdomain_name']);
            }
            return $data;
        } catch (\Exception $e) {
            return [];
        }
    }

    public function addDomain($domain)
    {
        try {
            $data = $this->params;
            $data['domain'] = $domain;
            return $this->request('POST', setting_value('visiosoft.extension.site_widget::site_add_domain_api'), [], $data);
        } catch (\Exception $e) {
            return [];
        }
    }

    public function addSSL($domain)
    {
        $data = $this->params;
        $data['domain'] = $domain;
        $results = $this->request('POST', setting_value('visiosoft.extension.site_widget::site_add_domain_ssl_api'), [], $data
        );
        if ($results['code'] == 200) {
            return $results['results'];
        }
    }


    public function request($method, $url, $data, $queryString)
    {
        $client = new Client();
        $queryString = http_build_query($queryString);
        $options = [
            'headers' => [
                'Accept' => 'application/json',
                'locale' => $this->request->session()->get('_locale') ? $this->request->session()->get('_locale') : 'en',
            ]
        ];
        if (!empty($data)) {
            $options['headers']['body'] = json_encode($data);
        }
        $url = $url . '?' . $queryString;
        $response = $client->request($method, $url, $options);
        return json_decode($response->getBody(), true);
    }
}
