<?php namespace Visiosoft\SiteWidgetExtension\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\Streams\Platform\Http\Controller\ResourceController;

class ApiController extends ResourceController {

    public $erCodes = [401, 400, 422, 412, 403, 404, 500, 503];

    public function sendResponse($data, $message = '')
    {
        $result = [
            'success' => true,
            'data' => $data,
            'message' => $message,
            'error_code' => 0
        ];
        return response()->json($result);
    }

    public function sendError($message, $code = 404, $data = [])
    {
        $result = [
            'success' => false,
            'data' => $data,
            'message' => $message,
            'error_code' => $code
        ];
        return response()->json($result, $code);
    }

    public function sendExceptionError($e)
    {
        $message = 'Error';
        if (env('APP_DEBUG')) {
            $message = $e->getMessage() . ' Line: ' . $e->getLine();
        }
        return $this->sendError($message, (!in_array($e->getCode(), $this->erCodes)) ? 500 : $e->getCode());
    }
}