function setURLSectionParam(value) {
    let url = window.location.href + '#' + value
    history.pushState(null, null, url)
}

let hashtag = window.location.hash;
let url = window.location.href;
if (hashtag.indexOf('#domains_modal') >= 0) {
    if (url.indexOf(hashtag) >= 0) {
        $("#domainsModal").modal('show');
    }
}
$("#domainsModal").on('hidden.bs.modal', function () {
    if (hashtag.indexOf('#domains_modal') >= 0) {
        let new_url = url.replace(/#domains_modal/g, '');
        history.pushState(null, null, new_url);
    }

})

function checkSSLStatus(id) {
    $('.ssl-' + id).css('animation', 'spin 2s linear infinite')
    window.location.reload()
}

function checkDomainStatus(id) {
    $('.domain-' + id).css('animation', 'spin 2s linear infinite')
    window.location.reload()
}

$.ajaxSetup({
    headers: {
        'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
    }
});
$("#addDomainForm").submit(function (e) {
    e.preventDefault()
    $('.form-error').empty().addClass('btn-hide').removeClass('btn-show')
    $('.form-success').empty().addClass('btn-hide').removeClass('btn-show')
    $('.btn-content').addClass('btn-hide').removeClass('btn-show')
    $('.btn-loading').addClass('btn-show').removeClass('btn-hide')
    $.ajax({
        url: '/api/site-widget/add-domain',
        method: 'POST',
        data: {
            domain: 'http://' + $('#domainName').val()
        },
    }).success((success) => {
        $('.form-error').empty().addClass('btn-hide').removeClass('btn-show')
        $('.form-success').text(success.message).removeClass('btn-hide').addClass('btn-show')
        window.location.reload()
    }).error((error) => {
        $('.btn-content').removeClass('btn-hide').addClass('btn-show')
        $('.btn-loading').removeClass('btn-show').addClass('btn-hide')
        if (error.status === 422) {
            $('.form-error').text(error.responseJSON.errors.domain[0]).removeClass('btn-hide').addClass('btn-show')
        } else {
            $('.form-error').text(error.responseJSON.message).removeClass('btn-hide').addClass('btn-show')
        }
    })
})

Paddle.Setup({vendor: 4062});

function openCheckout(id, email = null) {
    Paddle.Checkout.open({
        product: id,
        email: email,
        closeCallback: "checkoutClose",
        successCallback: "checkoutComplete",
    });
}

$('.buy').on('click', (e) => openCheckout($(e.target).data('id')));

function checkoutClose() {
    $("#renewModal").modal('toggle')
}

function checkoutComplete() {
    $("#renewModal").modal('toggle')
    window.location.reload()
}