<?php namespace Visiosoft\SiteWidgetExtension\Http\Service;

use GuzzleHttp\Client;
use Illuminate\Http\Request;

class SiteApiService
{
    protected $params;

    public function __construct(Request $request)
    {
        $this->params = [
            'token' => setting_value('visiosoft.extension.site_widget::site_service_token'),
            'subdomain' => setting_value('visiosoft.extension.site_widget::site_service_subdomain'),
            'locale' => $request->session()->get('_locale') ? $request->session()->get('_locale') : 'en'
        ];
    }

    public function getDomainsList()
    {
        try {
            $params = $this->params;
            $results = $this->getRequest(setting_value('visiosoft.extension.site_widget::site_domain_list_api'), $params);
            return $results['data'];
        } catch (\Exception $e) {
            return [];
        }
    }

    public function getSitePlans()
    {
        try {
            $results = $this->getRequest(setting_value('visiosoft.extension.site_widget::site_plans_api'));
            return $results['data'];
        } catch (\Exception $e) {
            return [];
        }
    }

    public function getSiteDetails()
    {
        try {
            $params = $this->params;
            $results = $this->getRequest(setting_value('visiosoft.extension.site_widget::site_detail_api'), $params);
            $detail = $results['data'][0];
            $data = [];
            $startedAt = strtotime($detail['created_at']);
            $endedAt = strtotime($detail['created_at']) + $detail['remaining_day'] * 86400;
            $data['remaining_day'] = $detail['remaining_day'] - (int)round((time() - $startedAt) / 86400);
            $data['started_at'] = date('d m Y', $startedAt);
            $data['ended_at'] = date('d m Y', $endedAt);
            $percent = round((((time() - $startedAt) / ($endedAt - $startedAt))) * 100);
            $data['percentage'] = $percent . '%';
            $data['plan_name'] = $detail['plan_name'];
            if ($percent > 100) {
                $data['percentage'] = '100%';
            }
            if ($percent < 0) {
                $data['percentage'] = '0';
            }
            if ($data['remaining_day'] < 0) {
                $data['remaining_day'] = 0;
            }
            return $data;
        } catch (\Exception $e) {
            return [];
        }
    }

    public function addDomain($domain)
    {
        try {
            $data = $this->params;
            $data['domain'] = $domain;
            $results = $this->postRequest(setting_value('visiosoft.extension.site_widget::site_add_domain_api'), $data);
            if ($results['code'] == 200) {
                return $results['results'];
            }
            throw new \Exception();
        } catch (\Exception $e) {
            return [];
        }
    }

    public function addSSL($domain)
    {
        $data = $this->params;
        $data['domain'] = $domain;
        $results = $this->postRequest(setting_value('visiosoft.extension.site_widget::site_add_domain_ssl_api'), $data);
        if ($results['code'] == 200) {
            return $results['results'];
        }
    }

    public function postRequest($url, $data = [])
    {
        $client = new Client();
        $options = [
            'headers' => [
                'Accept' => 'application/json',
            ],
        ];
        $response = $client->request('post', $url . '?' . http_build_query($data), $options);
        return ['results' => json_decode($response->getBody(), true), 'code' => $response->getStatusCode()];
    }

    public function getRequest($url, $params = [])
    {
        $client = new Client();
        $queryString = http_build_query($params);
        $response = $client->request('get', $url . '?' . $queryString);
        return json_decode($response->getBody(), true);
    }
}
