<?php namespace Visiosoft\SiteWidgetExtension\Http\Controller\Api;

use Visiosoft\SiteWidgetExtension\Http\Controller\ApiController;
use Visiosoft\SiteWidgetExtension\Http\Request\AddDomainRequest;
use Visiosoft\SiteWidgetExtension\Http\Request\AddSSLRequest;
use Visiosoft\SiteWidgetExtension\Http\Service\SiteApiService;

class DomainController extends ApiController {

    protected $siteApiService;
    public function __construct(SiteApiService $siteApiService)
    {
        $this->siteApiService = $siteApiService;
        parent::__construct();
    }

    public function addDomain(AddDomainRequest $request) {
        try {
            $inputs = $request->all();
            $domain = str_replace('http://', '',$inputs['domain']);
            $result = $this->siteApiService->addDomain($domain);
            if (!empty($result['data'])) {
                return $this->sendResponse($result, trans('visiosoft.extension.site_widget::field.domain_added_successfully'));
            }
            if (!$result['status']) {
                return $this->sendError($result['message'],421);
            }
        } catch (\Exception $e) {
            return $this->sendExceptionError($e);
        }
    }

    public function addSSL(AddSSLRequest $request) {
        try {
            $inputs = $request->all();
            $domain = str_replace('http://', '',$inputs['domain']);
            $result = $this->siteApiService->addSSL($domain);
            if (empty($result)) {
                throw new \Exception('Server Error');
            }
            if (!empty($result['data'])) {
                return $this->sendResponse($result, trans('visiosoft.extension.site_widget::field.domain_ssl_installation_sent'));
            }
                if (!$result['status']) {
                return $this->sendError($result['message'],422);
            }
        } catch (\Exception $e) {
            return $this->sendExceptionError($e);
        }
    }
}