<?php namespace Visiosoft\SiteModule\Console;

use Illuminate\Console\Command;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\GuideForYesterdayOpenedSites;


class SendGuide extends Command
{
    protected $name = 'send-guide';

    public function handle(SiteRepositoryInterface $siteRepository)
    {
        $day = setting_value('visiosoft.module.site::send_guide_after_days');

        $sites = $siteRepository->getUnguidedSitesWithDay($day);

        foreach ($sites as $site) {
            $send_status = event(new GuideForYesterdayOpenedSites($site));

            if (array_first($send_status)) {
                $site->update(['guide_mail' => true]);
            }
        }
    }
}
