<?php namespace Visiosoft\SiteModule\Console;

use Illuminate\Console\Command;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\SiteModule\Addon\Contract\AddonRepositoryInterface;
use Visiosoft\SiteModule\Bundle\Contract\BundleRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\AddMultipleAddonSite;
use Visiosoft\SiteModule\Site\Event\CheckActivatedSite;
use Visiosoft\SiteModule\Site\Event\CompletedInstallationSite;


class CheckActivateSites extends Command
{
    protected $name = 'check:activate-sites';

    public function handle(
        SiteRepositoryInterface $siteRepository,
        BundleRepositoryInterface $bundleRepository,
        CustomFieldRepositoryInterface $customFieldRepository,
        AddonRepositoryInterface $addonRepository
    )
    {

        $pending_sites = $siteRepository->getPendingSites();

        foreach ($pending_sites as $site) {
            $result = array_first(event(new CheckActivatedSite($site)));
            if ($result) {
                $site->changeStatus('completed',['enabled' => true]);

                event(new CompletedInstallationSite($site));

                if (!$site->app) {
                    $install_addons = [
                        ["type" => 'extension', "name" => 'site_widget'],
                        ["type" => 'extension', "name" => 'ads_widget'],
                        ["type" => 'extension', "name" => 'ads_chart_widget'],
                    ];

                    if ($site->default_theme && $bundle = $bundleRepository->find($site->default_theme)) {
                        // Move the ones with 'data' (seeder) in the name to the end of the array for loading last
                        $bundle_addons = $bundle->addons->map(function ($addon) use ($customFieldRepository) {
                            $addon_cf_name = $customFieldRepository->getAdValueByCustomFieldSlug('addon_composer_name', $addon->id);
                            $addon_array = explode('-', $addon_cf_name);
                            return [
                                'type' => $addon_array[1] ?? null,
                                'name' => $addon_array[0] ?? null,
                            ];
                        })->sortBy(function ($addon) {
                            return str_contains($addon['name'], 'data');
                        })->toArray();


                        $install_addons = array_merge($install_addons, $bundle_addons);

                        foreach ($install_addons as $addon)
                        {
                            $addonRepository->create([
                                'subdomain' => $site,
                                'addon' => implode('-',$addon),
                                'payment' => false,
                                'installed' => true,
                            ]);
                        }
                    }

                    event(new AddMultipleAddonSite($site, $install_addons));
                }
            }
        }
    }
}
