<?php namespace Visiosoft\SiteModule\AddonTrial;

use Carbon\Carbon;
use Visiosoft\SiteModule\AddonTrial\Contract\AddonTrialRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class AddonTrialRepository extends EntryRepository implements AddonTrialRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var AddonTrialModel
     */
    protected $model;

    /**
     * Create a new AddonTrialRepository instance.
     *
     * @param AddonTrialModel $model
     */
    public function __construct(AddonTrialModel $model)
    {
        $this->model = $model;
    }

    public function getExpiredTrials()
    {
        return $this->getModel()
        ->where('expires_at', '<', Carbon::now())
        ->where('removed', false)
        ->get();
    }
}
