<?php namespace Visiosoft\SiteModule;

use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\SiteModule\Notifications\SiteModuleNotificationsTemplateSeeder;

class SiteModuleSeeder extends Seeder
{
    protected $fieldRepository;
    protected $assignmentRepository;
    protected $streamRepository;

    public function __construct(
        FieldRepositoryInterface $fieldRepository,
        AssignmentRepositoryInterface $assignmentRepository,
        StreamRepositoryInterface $streamRepository
    )
    {
        $this->fieldRepository = $fieldRepository;
        $this->assignmentRepository = $assignmentRepository;
        $this->streamRepository = $streamRepository;
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        if (is_module_installed('visiosoft.module.customfields')) {
            $customFieldRepository = app(CustomFieldRepositoryInterface::class);
            $customFieldRepository->newQuery()->firstOrCreate(
                ['slug' => str_slug(trans('visiosoft.module.site::field.addon_composer_name'), '_')],
                ['name' => trans('visiosoft.module.site::field.addon_composer_name'), 'type' => 'text']
            );
        }

        $user_fields = [
            [
                'name' => 'utm_source',
                'slug' => 'utm_source',
                'type' => 'anomaly.field_type.text',

            ],
            [
                'name' => 'utm_medium',
                'slug' => 'utm_medium',
                'type' => 'anomaly.field_type.text',

            ],
            [
                'name' => 'utm_campaign',
                'slug' => 'utm_campaign',
                'type' => 'anomaly.field_type.text',

            ],
            [
                'name' => 'utm_term',
                'slug' => 'utm_term',
                'type' => 'anomaly.field_type.text',

            ],
            [
                'name' => 'utm_content',
                'slug' => 'utm_content',
                'type' => 'anomaly.field_type.text',

            ],
            [
                'name' => 'browser_lang',
                'slug' => 'browser_lang',
                'type' => 'anomaly.field_type.text',

            ],
            [
                'name' => 'location_for_ip',
                'slug' => 'location_for_ip',
                'type' => 'anomaly.field_type.text',

            ]
        ];

        foreach ($user_fields as $user_field) {
            $stream = $this->streamRepository->findBySlugAndNamespace('users', 'users');

            if (!$field = $this->fieldRepository->findBySlugAndNamespace($user_field['slug'], 'users')) {
                $field = $this->fieldRepository->create([
                    'name' => $user_field['name'],
                    'namespace' => 'users',
                    'slug' => $user_field['slug'],
                    'type' => $user_field['type'],
                    'locked' => 0
                ]);
            }

            $assigment = $this->assignmentRepository->findByStreamAndField($stream, $field);
            if (!$assigment) {
                $this->assignmentRepository->create([
                    'stream_id' => $stream->getId(),
                    'field_id' => $field->getId()
                ]);
            }
        }

        //Notifications Templates
        $this->call(SiteModuleNotificationsTemplateSeeder::class);

        // Variables Seed
        if (!$stream = $this->streamRepository->findBySlugAndNamespace('site_module', 'variables')) {
            $stream = $this->streamRepository->newQuery()
                ->create([
                    'name' => 'site_module',
                    'namespace' => 'variables',
                    'slug' => 'site_module',
                    'prefix' => 'variables_',
                    'translatable' => true,
                ]);
        }

        if (!$field = $this->fieldRepository->findBySlugAndNamespace('trial_modal_subdomain_information', 'variables')) {
            $field = $this->fieldRepository->newQuery()
                ->create([
                    'name' => 'trial_modal_subdomain_information',
                    'namespace' => 'variables',
                    'slug' => 'trial_modal_subdomain_information',
                    'type' => 'anomaly.field_type.wysiwyg',
                    'locked' => false,
                ]);
        }

        if (!$this->assignmentRepository->findByStreamAndField($stream, $field)) {
            $this->assignmentRepository->newQuery()
                ->create([
                    'stream_id' => $stream->id,
                    'field_id' => $field->id,
                    'translatable' => true,
                ]);
        }

    }
}
