<?php namespace Visiosoft\SiteModule\Site;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Visiosoft\ConnectModule\Command\CheckRequiredParams;
use Visiosoft\SubscriptionsModule\Subscription\Contract\SubscriptionRepositoryInterface;

class SiteApiCollection extends SiteRepository
{
    use DispatchesJobs;

    public function detail(array $params)
    {
        $this->dispatch(new CheckRequiredParams(['token'], $params));

        $subscription_repository = app(SubscriptionRepositoryInterface::class);

        $site = $this->newQuery()
            ->where('api_token', $params['token'])
            ->first();

        if (!$site) {
            throw new \Exception(trans('visiosoft.module.connect::message.not_found', ['name' => 'Site']), 404);
        }

        if ($subscription = $subscription_repository->find($site->subscription_id)) {
            $site->remaining_day = $subscription->getRemaining();
            $site->plan_name = $subscription->getPlan()->name;
        }

        return $site;
    }
}
