<?php namespace Visiosoft\SiteModule\Site\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class DeleteSite implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $site;

    public $tries = 3;

    public function __construct($site)
    {
        $this->site = $site;
    }

    public function retryUntil()
    {
        return now()->addMinutes(10);
    }

    public function handle()
    {
        $response = array_first(event(new \Visiosoft\SiteModule\Site\Event\DeleteSite($this->site)));

        if ($response['status']) {
            $this->site->terminate();
        } else {
            $this->site->updateDeleteStatus('error');
        }

    }
}
