<?php namespace Visiosoft\SiteModule\Site\AddSslForm;

use Visiosoft\SiteModule\Domain\Contract\DomainRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\InstallSSL;


class AddSslFormHandler
{
    public function handle(
        AddSslFormBuilder $builder,
        SiteRepositoryInterface $siteRepository,
        DomainRepositoryInterface $domainRepository
    )
    {

        if (!$builder->canSave()) {
            return;
        }

        if ($site = $siteRepository->find(request('site'))) {

            $domains = $builder->getPostValue('domains');

            foreach ($domains as $domain) {
                if ($domain = $domainRepository->find($domain)) {
                    event(new InstallSSL($site, $domain));
                }
            }
        }
    }
}
