<?php namespace Visiosoft\SiteModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Anomaly\Streams\Platform\Support\Currency;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\SiteModule\Addon\Contract\AddonRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Traits\CheckAddonSiteTrait;

class AddonsController extends ResourceController
{
    use CheckAddonSiteTrait;

    private $addon;
    private $ad;
    private $site;
    private $cf;

    public function __construct(
        AddonRepositoryInterface $addon,
        CustomFieldRepositoryInterface $cf,
        AdvRepositoryInterface $ad,
        SiteRepositoryInterface $site)
    {
        $this->addon = $addon;
        $this->ad = $ad;
        $this->site = $site;
        $this->cf = $cf;
        parent::__construct();
    }


    public function AddCart()
    {
        $request = request()->all();

            if (!$is_addon_installed) {

                $addonRecord = $this->addon->createAddonForCart($site, $addon_slug, $addon_detail);

        $addon_slug = $this->cf->getAdValueByCustomFieldSlug('addon_composer_name', $request['addon']);

        if ($site and $site->status == "completed" and $addon_slug) {
            $is_addon_installed = $this->addon->isAddonInstalled($addon_slug,$site->id);

            if (!$is_addon_installed) {

                $addonRecord = $this->addon->createAddonForCart($site, $addon_slug, $addon_detail);

                $addonRecord->name = $addon_detail->name;
                $addonRecord->price = $addon_detail->price;
                $addonRecord->currency = $addon_detail->currency;
                $cart = $this->dispatch(new GetCart());
                $cart->add($addonRecord, 1, $site->subdomain_name . "." . $site->type);
                if (isset($request['theme']) and $request['theme'] === 'oc'){
                    $thisModel = new AdvModel();
                    $adv = $thisModel->isAdv($request['addon']);
                    $response['status'] = "success";
                    $response['count'] = $cart->getItems()->count;
                    $response['item'] = [
                        'id' => $cart->getItems()->last->id,
                        'adv_id' => $cart->getItems()->last->entry_id,
                        'photo' => url($cart->getItems()->last->entry->entry->cover_photo),
                        'url' => $thisModel->getAdvDetailLinkByAdId($adv->id),
                        'name' => $adv->name,
                        'quantity' => $cart->getItems()->last->quantity,
                        'price' => app(Currency::class)->format($cart->getItems()->last->price, $cart->getItems()->last->currency),
                        'subtotal' => app(Currency::class)->format($cart->subtotal, setting_value('streams::currency'))
                    ];
                    return $response;
                }

                if (isset($request['isAjax']) and $request['isAjax']) {
                    return response()->json(['msg' => trans("visiosoft.module.site::message.notification.salutation"), 'status' => 200]);
                } else {
                    return redirect('cart');
                }

            }

            if (isset($request['isAjax']) and $request['isAjax']) {
                return response()->json(['msg' => trans('visiosoft.module.site::message.already_installed_addon'), 'status' => 400]);
            } else {
                $this->messages->error(trans('visiosoft.module.site::message.already_installed_addon'));
            }

        }

        if (isset($request['isAjax']) and $request['isAjax']) {
            return response()->json(['msg' => trans('visiosoft.module.site::message.error_add_cart_addon'), 'status' => 500]);
        } else {
            $this->messages->error(trans('visiosoft.module.site::message.error_add_cart_addon'));
            return back();
        }

    }

    public function checkAddon()
    {
        $this->checkInstalledAddon();
    }
}
