<?php namespace Visiosoft\SiteModule\Site\AddBundleForm;

use Anomaly\Streams\Platform\Message\MessageBag;
use Illuminate\Support\Facades\DB;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\SiteModule\Addon\Contract\AddonRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\AddMultipleAddonSite;


class AddBundleFormHandler
{
    public function handle(
        AddBundleFormBuilder $builder,
        SiteRepositoryInterface $site,
        CustomFieldRepositoryInterface $cf,
        MessageBag $message,
        AddonRepositoryInterface $addon
    )
    {

        if (!$builder->canSave()) {
            return;
        }

        $parameters = $builder->getPostData();


        $addons = DB::table('site_bundles_addons')
            ->where('entry_id', $builder->getPostValue('bundle'))
            ->get()
            ->pluck('related_id')
            ->all();


        if ($site = $site->find($parameters['subdomain']) and count($addons)) {
            $install_addons = array();
            foreach ($addons as $item) {
                if ($is_addon = $cf->getAdValueByCustomFieldSlug('addon_composer_name', $item)) {

                    $addon_array = explode('-', $is_addon);
                    if (count($addon_array) < 2) {
                        $message->error(trans('visiosoft.module.site::message.error_addon_slug', ['addon_name' => "#" . $item->name . "-" . $item->name]));
                    } else {
                        $install_addons[] = ["type" => $addon_array[1], "name" => $addon_array[0]];

                        $addon->create([
                            'subdomain' => $site,
                            'addon' => $is_addon,
                            'payment' => false,
                            'installed' => 'pending',
                            'entry_id' => $item,
                            'entry_type' => 'Visiosoft\AdvsModule\Adv\AdvModel'
                        ]);

                        $message->success(trans('visiosoft.module.site::message.addAddon'));
                    }

                } else {
                    $message->error(trans('visiosoft.module.site::message.error_addon_slug', ['addon_name' => "#" . $item->name . "-" . $item->name]));
                }
            }
            if (count($install_addons)) {
                event(new AddMultipleAddonSite($site, $install_addons));
            }
        }
    }
}
