<?php namespace Visiosoft\SiteModule\Site\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Visiosoft\SiteModule\Site\Event\BackupStatusChange;

class ChangeBackupStatus implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $site;

    public $tries = 3;

    public function __construct($site)
    {
        $this->site = $site;
    }

    public function retryUntil()
    {
        return now()->addMinutes(10);
    }

    public function handle()
    {
        event(new BackupStatusChange($this->site));
    }
}
