<?php namespace Visiosoft\CloudsiteModule\Http\Controller\Admin;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\SettingsModule\Setting\SettingRepository;
use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Illuminate\Http\Request;
use Visiosoft\CloudsiteModule\Site\Event\DeleteSite;
use Visiosoft\CloudsiteModule\Site\Event\SuspendSite;
use Visiosoft\CloudsiteModule\Site\Event\UpdateSite;
use Visiosoft\CloudsiteModule\Site\Form\SiteFormBuilder;
use Visiosoft\CloudsiteModule\Site\SiteModel;
use Visiosoft\CloudsiteModule\Site\Table\SiteTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Illuminate\Contracts\Events\Dispatcher;


class SitesController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param SiteTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(SiteTableBuilder $table, Request $request, Dispatcher $events,SettingRepositoryInterface $settings)
    {
        if ($request->action == 'delete') {
            foreach ($request->id as $id)
            {
                $SiteModel = new SiteModel();
                $subdomain = $SiteModel->getSite($id)->subdomain;
                $events->dispatch(new DeleteSite($subdomain,$settings));
            }

        }
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param SiteFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(SiteFormBuilder $form, Dispatcher $events)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param SiteFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function update(Dispatcher $events,SettingRepositoryInterface $settings, $id)
    {
        $SiteModel = new SiteModel();
        $subdomain = $SiteModel->getSite($id)->subdomain;
        $events->dispatch(new UpdateSite($subdomain,$settings));
        return redirect('/admin/cloudsite')->with('info', [trans('visiosoft.module.cloudsite::message.update_site.message')]);
    }

    public function suspend(Dispatcher $events,SettingRepositoryInterface $settings, $id)
    {
        $site = array();
        $site['suspend'] = "true";
        $SiteModel = new SiteModel();
        $site['subdomain'] = $SiteModel->getSite($id)->subdomain;;
        $events->dispatch(new SuspendSite($site,$settings));
        return redirect('/admin/cloudsite')->with('info', [trans('visiosoft.module.cloudsite::message.suspend_site.message')]);
    }

    public function unsuspend(Dispatcher $events,SettingRepositoryInterface $settings, $id)
    {
        $site = array();
        $site['suspend'] = "false";
        $SiteModel = new SiteModel();
        $site['subdomain'] = $SiteModel->getSite($id)->subdomain;;
        $events->dispatch(new SuspendSite($site,$settings));
        return redirect('/admin/cloudsite')->with('info', [trans('visiosoft.module.cloudsite::message.unsuspend_site.message')]);
    }
}
