function validateEmail($email) {
    var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
    return emailReg.test($email);
}

$('.try-demo-openclassify').on('click', function () {
    $('#freetrialForm').modal('toggle');
});

$(()=> {
    $('.next_second_step').on('click', function () {

        /* Trial Form Validate Req */
        let fieldErrors = $('.formErrors.field');
        let termOfUseErrors = $('.formErrors.term_of_use_error');
        let subdomain = $('#freeTrialModal input[name="subdomain"]').val();
        let domain = $('#freeTrialModal select[name="domain"]').val();
        let email = $('#freeTrialModal input[name="email"]').val();
        let name_surname = $('#freeTrialModal input[name="name_surname"]').val();

        if ($('#freeTrialModal input[name="term_of_use"]:checked').val() !== 'true') {
            termOfUseErrors.append("<p class='mb-0'><i class='fa fa-exclamation-triangle'></i>" + errorList['term_of_use'] + "</p>");
        } else {
            $.ajax({
                type: 'POST',
                data: {
                    subdomain: subdomain,
                    domain: domain,
                    email: email,
                    name_surname: name_surname,
                },
                url: '/ajax/registerValidate',
                beforeSend: function () {
                    fieldErrors.html('');
                    termOfUseErrors.html('');
                    $('#freeTrialModal').find('.invalid').removeClass('invalid');
                },success: function (response) {
                    if (response.status === 'error'){
                        $.each(response.msg, (key, msg)=>{
                            fieldErrors.append("<p><i class='fa fa-exclamation-triangle'></i>" + msg + "</p>");
                        })
                    } else if (response.status === 'success') {
                        $('#freeTrialModal .modal-dialog').addClass('modal-lg');
                        $('.one_step, .two_step').toggleClass('d-none');
                    }
                }, error: function (reject) {
                    $.each($.parseJSON(reject.responseText).errors, (key, msg) => {
                        $('#freeTrialModal input[name="'+ key +'"]').addClass('invalid');
                        $('#freeTrialModal select[name="'+ key +'"]').addClass('invalid');
                    });
                }
            })
        }
    });

    $('.next_third_step').on('click', function () {
        $('#freeTrialModal .modal-dialog.modal-lg').removeClass('modal-lg')
        $('.two_step, .three_step').toggleClass('d-none');
    });

    let locale = 'en';
    $('.lang_select_area').on('click', function () {
        locale = $(this).parent().find('input').val();
        $('.three_step, .loading_area').toggleClass('d-none');
        $('#ocTrialForm').submit();
    })

    $("#trialForm, #ocTrialForm").submit(function (e) {
        e.preventDefault();

        let thisForm = $(this).attr('id');
        let formErrors = $('.formErrors');
        let form = $("#" + thisForm);
        let email = $(this).find('input[name="email"]').val();
        let name = $(this).find('input[name="name_surname"]').val();
        let phone = $("input[name='phone']").val();
        let storename = (thisForm === 'ocTrialForm') ?  $("input[name='subdomain']").val() : $("input[name='storename']").val()
        storename = storename.replace(/[^a-zA-Z0-9]/g, "").replace(/ /g, '');
        let theme = $('#freeTrialModal input[name="theme"]:checked').val();

        /*** Validation Email */
        if (validateEmail(email)) {

            var passthrough = {
                'name_surname': name,
                "email": email,
                'storename': storename,
                'phone': phone,
                'theme': theme,
                'locale': locale,
            };
            $.ajax({
                type: 'POST',
                data: passthrough,
                url: '/ajax/registerUser',
                beforeSend: function () {
                    $('#freetrialForm').find('.loadingSubmit').toggleClass('d-none');
                    $('#freetrialForm,  #ocTrialForm').find('.submitBtn').prop("disabled", true);
                },
                success: function (c) {
                    formErrors.html("");
                    if (c.status == "success") {

                        //Conversion tracking tag
                        window.dataLayer = window.dataLayer || [];

                        function gtag() {
                            dataLayer.push(arguments);
                        }

                        gtag('js', new Date());
                        gtag('config', 'AW-604648196');

                        gtag('event', 'purchase', {
                            "transaction_id": c.user_id,
                            "value": 0,
                            "currency": "USD",
                        });

                        if (thisForm === 'ocTrialForm') {
                            $('#freeTrialModal').modal('hide')
                            $('#successModal').modal('toggle');
                        } else {
                            $('#freetrialForm').modal('hide');
                            $('#created-user-modal').modal('toggle');
                        }

                        form.trigger("reset");
                    } else {
                        /*** Show Error Icon */
                        $.each(c.type, function (i, t) {
                            if (t === false) {
                                $('.' + i).removeClass('d-none');
                                formErrors.append("<p><i class='fa fa-exclamation-triangle'></i>" + errorList[i] + "</p>");
                            } else {
                                if (!$('.' + i).hasClass('d-none')) {
                                    $('.' + i).addClass('d-none');
                                }
                            }
                        });
                    }
                },
                complete: function () {
                    $('.one_step, .loading_area').toggleClass('d-none');
                    $('#freetrialForm').find('.submitBtn').prop("disabled", false);
                    $('#freetrialForm, #ocTrialForm').find('.submitBtn').prop("disabled", false);
                    $('#freetrialForm').find('.loadingSubmit').toggleClass('d-none');
                }
            });
        }
    });
})
$('.tryFormOnlyEmail').on('submit', function (e) {
    e.preventDefault();
    $('#freetrialForm').find('input[type="email"]').val($('.tryFormOnlyEmail').find('.email').val());
    $('#freetrialForm').modal('toggle');
});
