<?php namespace Visiosoft\SiteModule\Site\Listener;

use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\CreateSite;
use Visiosoft\SubscriptionsModule\Subscription\Event\SubscriptionCreated;

class CreatedNewSubscription
{
    private $site;
    private $user;

    public function __construct(SiteRepositoryInterface $site, UserRepositoryInterface $user)
    {
        $this->site = $site;
        $this->user = $user;
    }

    public function handle(SubscriptionCreated $event)
    {
        $subscription = $event->getSubscription();
        $user = $subscription->assign;

        $site = $this->site->findBySubdomain($event->getSubdomain());
        if (is_null($site)) {
            return "error";
        } else {
            $site->update(
                ['status' => 'pending']
            );
            $new_site = event(new CreateSite([
                'subdomain_name' => $event->getSubdomain(),
                'assign' => $user->getId(),
                'password' => $site->password,
                'type' => $site->type,
            ]));

            $return = array_first($new_site);

            if ($return['status'] !== true) {
                $site->update(
                    ['status' => 'error', 'message' => $return['message']]
                );
            }
            return $site;
        }

    }
}
