<?php namespace Visiosoft\SiteModule\Traits;

use Carbon\Carbon;
use Visiosoft\SiteModule\Addon\Contract\AddonRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\CheckCompletedAddonInstall;
use Visiosoft\SiteModule\Site\Event\InstalledAddon;

trait CheckAddonSiteTrait
{

    public function checkInstalledAddon()
    {
        $addon = app(AddonRepositoryInterface::class);

        $pending_addons = $addon->getPendings();

        foreach ($pending_addons as $addon) {
            if ($addon->subdomain) {
                $response = array_first(event(new CheckCompletedAddonInstall($addon->subdomain, $addon->addon)));

                if ($response) {
                    event(new InstalledAddon($addon));

                    $addon->update(['installed' => true]);
                } elseif ($addon->created_at) {

                    $date = Carbon::parse($addon->created_at->format('Y-m-d H:i:s'));
                    $now = Carbon::now();

                    if ($date->diffInDays($now) > 0) {
                        $addon->update(['installed' => 'error']);
                    }
                }
            }
        }
    }
}