<?php namespace Visiosoft\SiteModule\Site\Form;

class SiteFormFields
{
    public function handle(SiteFormBuilder $builder)
    {
        $fields = [
            'reinstall_addons',
            'backup_status',
            'assign',
            'locale',
            'api_token',
        ];
        if ($builder->getFormMode() === 'edit') {
            $builder->setFields(array_merge([
                'status' => [
                    'type' => 'anomaly.field_type.select',
                    'config' => [
                        'options' => [
                            'completed' => 'module::field.completed',
                            'error' => 'module::field.error',
                            'pending' => 'module::field.pending',
                            'incomplete' => 'module::field.incomplete',
                        ],
                    ],
                ],
                'message',
                'update_at',
                'suspend_at',
                'deletedCwp',
                'password' => [
                    'disabled' => true,
                ],
                'node' => [
                    'disabled',
                ],
                'auto_refresh' => [
                    'disabled',
                    'attributes' => [
                        'class' => 'd-none'
                    ],
                ],
            ],$fields));
        } else {
            $builder->setFields(array_merge([
                'subdomain_name' => [
                    'type' => 'anomaly.field_type.slug',
                    'config' => [
                        'type' => '-',
                        'max' => 8,
                    ],
                ],
                'type' => [
                    'type' => 'anomaly.field_type.select',
                    'config' => [
                        'options' => function () {
                            $domains = setting_value('visiosoft.module.site::demo_domains');
                            return array_combine($domains, $domains);
                        }
                    ]
                ],
                'node' => [
                    'value' => function () {
                        return setting_value('visiosoft.module.site::default_node_server');
                    },
                ],
                'password',
                'auto_refresh',
            ],$fields));
        }

    }
}
