$(() => {
    function limitText(field, maxChar) {
        let ref = $(field),
            val = ref.val();
        if (val.length >= maxChar) {
            ref.val(function () {
                return val.substr(0, maxChar);
            });
        }
    }

    $(function () {
        $('.digit-input').each(function () {
            $(this).attr('maxlength', 1);
            $(this).on('keyup', function (e) {
                limitText(this, 1);
                let filled = true;
                $('.digit-input').each(function (index, element) {
                    let ref = $(element),
                        val = ref.val()
                    if (val.length === 0) {
                        filled = false;
                        $('.activation-action-btn').addClass('disabled').prop('disabled', true);
                    }
                })
                if (filled) {
                    $('.activation-action-btn').removeClass('disabled').prop('disabled', false);
                }
                let parent = $($(this).parent());
                if (e.keyCode === 8 || e.keyCode === 37) {
                    let prev = parent.find('input#' + $(this).data('previous'));
                    if (prev.length) {
                        $('.activation-action-btn').addClass('disabled').prop('disabled', true);
                        $(prev).select();
                    }
                } else if (
                    (e.keyCode >= 48 && e.keyCode <= 57)
                    || (e.keyCode >= 65 && e.keyCode <= 90)
                    || (e.keyCode >= 96 && e.keyCode <= 105)
                    || e.keyCode === 39) {
                    let next = parent.find('input#' + $(this).data('next'));
                    if (next.length > 0) {
                        $(next).select();
                    }
                }
            });
        });
        $(document).on('click', '.next_third_step', function () {
            $('#freeTrialModal .modal-dialog').addClass('modal-lg')
        });
    })
    let country = document.getElementById('default-phone-country')
        ? document.getElementById('default-phone-country').innerText : null;
    let phone = document.querySelector('#phone');
    const iti = intlTelInput(phone, {
        class: "phone",
        initialCountry: "auto",
        formatOnDisplay: true,
        nationalMode: true,
        hiddenInput: phone.name,
        utilsScript: 'utils/utils.js',
        geoIpLookup: function (success, failure) {
            $.get("https://ipinfo.io", function () {
            }, "jsonp").always(function (resp) {
                var countryCode = country ? country : (resp && resp.country) ? resp.country : "";
                success(countryCode);
            })
        }
    });

    addMask(iti, phone);
    $(phone).on("countrychange", function (event) {
        iti.setNumber("");
        addMask(iti, phone);
    });

    function addMask(iti, phone) {
        let selectedCountryData = iti.getSelectedCountryData();
        let newPlaceholder = intlTelInputUtils.getExampleNumber(selectedCountryData.iso2, true, intlTelInputUtils.numberFormat.INTERNATIONAL);
        $(phone).inputmask({mask: newPlaceholder.replace(/[0-9+]/ig, '9'), keepStatic: false});
    }

    function controlNumber(phone) {
        var iti = intlTelInput(phone, {
            hiddenInput: phone.getAttribute('name'),
            class: "phone",
            initialCountry: "auto",
            geoIpLookup: function (success, failure) {
                $.get("https://ipinfo.io", function () {
                }, "jsonp").always(function (resp) {
                    var countryCode = (resp && resp.country) ? resp.country : "";
                    success(countryCode);
                })
            }
        })

        return iti.isValidNumber();
    }

    function validateEmail($email) {
        var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
        return emailReg.test($email);
    }

    $('.try-demo-openclassify').on('click', function () {
        $('#freetrialForm').modal('toggle');
    });

    let paddle_id;
    $('.try-demo-ocify').on('click', function (e) {
        paddle_id = $(e.target).data('id');
        $('#freeTrialModal').modal('toggle');
    });
    $('#freeTrialModal input[name="subdomain"]').on('keyup', () => {
        if ($('#freeTrialModal input[name="subdomain"]').val().length > 8) {
            $('.subdomain-max-length').removeClass('hidden');
        } else {
            $('.subdomain-max-length').addClass('hidden');
        }
    })
    $('.next_second_step').on('click', function (phone) {
        /* Trial Form Validate Req */
        let fieldErrors = $('.formErrors.field');
        let termOfUseErrors = $('.formErrors.term_of_use_error');
        let subdomain = $('#freeTrialModal input[name="subdomain"]').val();
        let domain = $('#freeTrialModal select[name="domain"]').val();
        let email = $('#freeTrialModal input[name="email"]').val();
        let name_surname = $('#freeTrialModal input[name="name_surname"]').val();

        if ($('#freeTrialModal input[name="term_of_use"]:checked').val() !== 'true') {
            termOfUseErrors.html("<p class='mb-0'><i class='fa fa-exclamation-triangle'></i>" + errorList['term_of_use'] + "</p>");
        } else {
            $.ajax({
                type: 'POST',
                data: {
                    subdomain: subdomain,
                    domain: domain,
                    email: email,
                    name_surname: name_surname,
                },
                url: '/ajax/registerValidate',
                beforeSend: function () {
                    fieldErrors.html('');
                    termOfUseErrors.html('');
                    $('#freeTrialModal').find('.invalid').removeClass('invalid');
                }, success: function (response) {
                    if (response.status === 'error') {
                        $.each(response.msg, (key, msg) => {
                            fieldErrors.append("<p><i class='fa fa-exclamation-triangle'></i>" + msg + "</p>");
                        })
                    } else if (response.status === 'success') {
                        $('#freeTrialModal .modal-dialog').addClass('modal-lg');
                        $('.one_step, .two_step').toggleClass('d-none');
                    }
                }, error: function (reject) {
                    $.each($.parseJSON(reject.responseText).errors, (key, msg) => {
                        $('#freeTrialModal input[name="' + key + '"]').addClass('invalid');
                        $('#freeTrialModal select[name="' + key + '"]').addClass('invalid');
                    });
                }
            })
        }
    });

    $('.next_third_step').on('click', function () {
        $('.two_step, .three_step').toggleClass('d-none');
    });

    let locale = 'en';
    $('.lang_select_area').on('click', function () {
        locale = $(this).parent().find('input').val();
        $('.three_step, .forth_step').toggleClass('d-none');
        $('#ocTrialForm').submit();
    })
    var registeredUserEmail;
    $("#trialForm, #ocTrialForm").submit(function (e) {
        ///////////////////////////////////////////////////////////////////////////////////////
        // todo activate yandex metrica later #### important: i disabled it in my localhost ///
        // ym(66363319, 'reachGoal', 'trialFormSubmitted');////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////////////////
        e.preventDefault();
        let thisForm = $(this).attr('id');
        let formErrors = $('.formErrors');
        let form = $("#" + thisForm);
        let email = $(this).find('input[name="email"]').val();
        let name = $(this).find('input[name="name_surname"]').val();
        let phone = iti.getNumber();
        phone = phone.substring(1);
        let storename = (thisForm === 'ocTrialForm') ? $("input[name='subdomain']").val() : $("input[name='storename']").val()
        storename = storename.replace(/[^a-zA-Z0-9]/g, "").replace(/ /g, '');
        let theme = $('#freeTrialModal input[name="bundle"]:checked').val();
        /*** Validation Email */
        if (validateEmail(email)) {
            var passthrough = {
                'name_surname': name,
                "email": email,
                'storename': storename,
                'phone': phone,
                'theme': theme,
                'locale': locale,
            };
            $.ajax({
                type: 'POST',
                data: passthrough,
                url: '/ajax/registerUser',
                beforeSend: function () {
                    $('#freetrialForm,  #ocTrialForm').find('.submitBtn').prop("disabled", true);
                },
                success: function (c) {
                    formErrors.html("");
                    if (c.success) {
                        registeredUserEmail = c.data.email;
                    } else {
                        /*** Show Error Icon */
                        if (c.type) {
                            $.each(c.type, function (i, t) {
                                if (t === false) {
                                    $('.' + i).removeClass('d-none');
                                    formErrors.append("<p><i class='fa fa-exclamation-triangle'></i>" + errorList[i] + "</p>");
                                } else {
                                    if (!$('.' + i).hasClass('d-none')) {
                                        $('.' + i).addClass('d-none');
                                    }
                                }
                            });
                        } else {
                            formErrors.append(`<p><i class='fa fa-exclamation-triangle'></i>${c.message}</p>`);
                        }
                    }
                },
                complete: function () {
                    $('#freetrialForm').find('.submitBtn').prop("disabled", false);
                    $('#freetrialForm, #ocTrialForm').find('.submitBtn').prop("disabled", false);
                }
            });
        }
    });

    $("#addon_install").submit((e) => {
        e.preventDefault();
        const site = $("select[name='site']").val();
        const addon = $("input[name='addon']").val();
        $.ajax({
            type: 'POST',
            url: '/api/add-addon',
            data: {site, addon},
            success: (response) => {
                Swal.fire({
                    icon: 'success',
                    title: installationStart,
                    timerProgressBar: true,
                    showConfirmButton: false,
                    timer: 1500
                })
            },
            error: (err) => {
                Swal.fire({
                    icon: 'error',
                    title: addAddonError,
                    timerProgressBar: true,
                    showConfirmButton: false,
                    timer: 1500
                })
            }
        })
    })
    $('.tryFormOnlyEmail').on('submit', function (e) {
        e.preventDefault();
        $('#freetrialForm').find('input[type="email"]').val($('.tryFormOnlyEmail').find('.email').val());
        $('#freetrialForm').modal('toggle');
    });
    $('.activation-action-btn').on('click', function () {
        $('.activation-errors').html('').addClass('d-none')
        let data = {
            verification_code: '' + $('#digit-1').val() + $('#digit-2').val() + $('#digit-3').val() + $('#digit-4').val() + $('#digit-5').val() + $('#digit-6').val(),
            email: registeredUserEmail
        }
        $.ajax({
            url: '/ajax/userVerification',
            method: 'get',
            data: data,
            accept: 'application/json',
            success: (response) => {
                $('.activation-action-btn').props('disabled', true)
                $('.activation-errors').html('').addClass('d-none')
            },
            error: (error) => {
                if (error.status === 422) {
                    $('.activation-action-btn').props('disabled', false)
                    $('.activation-errors').html(error.responseJSON.errors.verification_code[0]).removeClass('d-none')
                }
            }
        })
    })
})
