<?php namespace Visiosoft\SiteModule;

use Anomaly\Streams\Platform\Addon\Module\Module;

class SiteModule extends Module
{

    /**
     * The navigation display flag.
     *
     * @var bool
     */
    protected $navigation = true;

    /**
     * The addon icon.
     *
     * @var string
     */
    protected $icon = 'fa fa-puzzle-piece';

    /**
     * The module sections.
     *
     * @var array
     */
    protected $sections = [
        'site' => [
            'buttons' => [
                'new_site',
                'check_site' => [
                    'icon' => 'refresh',
                    'href' => '/admin/site/check'
                ],
            ],
        ],
        'domain' => [
            'buttons' => [
                'new_domain',
            ],
        ],
        'addon' => [
            'buttons' => [
                'check_addon' => [
                    'icon' => 'refresh',
                    'href' => '/admin/addon/check'
                ],
            ],
        ],
        'settings' => [
            'href' => 'admin/settings/modules/visiosoft.module.site',
            'title' => 'visiosoft.module.site::section.settings.title'
        ],
    ];

}
