<?php namespace Visiosoft\SiteModule;

use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Visiosoft\SiteModule\Addon\Contract\AddonRepositoryInterface;
use Visiosoft\SiteModule\Domain\Contract\DomainRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Handler\CheckCreateSiteForSubscription;

class SiteModulePlugin extends Plugin
{
    public $site;
    public $addon;
    public $domain;

    public function __construct(
        SiteRepositoryInterface $site,
        AddonRepositoryInterface $addon,
        DomainRepositoryInterface $domain)
    {
        $this->site = $site;
        $this->addon = $addon;
        $this->domain = $domain;
    }

    /**
     * @return array
     */
    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction(
                'findByAssing',
                function ($user_id, $type = null) {
                    if (!$subdomains = $this->site->findByAssing($user_id, $type)) {
                        return null;
                    }
                    return $subdomains;
                }
            ),
            new \Twig_SimpleFunction(
                'getSiteForSubscription',
                function ($id) {
                    if (!$sites = $this->site->getSiteForSubscription($id)) {
                        return null;
                    }
                    return $sites;
                }
            ),
            new \Twig_SimpleFunction(
                'getAddonsBySite',
                function ($id) {
                    if (!$addons = $this->addon->getAddonsBySite([$id], true)) {
                        return null;
                    }
                    return $addons;
                }
            ),
            new \Twig_SimpleFunction(
                'getDomainsBySite',
                function ($id) {
                    if (!$domains = $this->domain->getDomainsBySite([$id])) {
                        return null;
                    }
                    return $domains;
                }
            ),
            new \Twig_SimpleFunction(
                'getLimitBySubscription',
                function ($id) {
                    return $this->dispatch(new CheckCreateSiteForSubscription($id, 'getLimit'));

                }
            ),
        ];
    }
}
