<?php namespace Visiosoft\SiteModule\Site;

use Visiosoft\SiteModule\Site\Contract\SiteInterface;
use Anomaly\Streams\Platform\Model\Site\SiteSiteEntryModel;

class SiteModel extends SiteSiteEntryModel implements SiteInterface
{

    /**
     * @return string
     * Get Site Url
     */
    public function getUrl()
    {
        return $this->subdomain_name . "." . $this->type;
    }

    /**
     * @param $status
     * Change Site Status
     */
    public function changeStatus($status)
    {
        $this->update(['status' => $status]);
    }

    /**
     * @param $message
     * @return mixed|void
     * Update Error Message
     */
    public function updateErrorMsg($message)
    {
        $this->update([
            'message' => $message,
            'status' => "error",
        ]);
    }

    /**
     * @param $id
     * Set Subscription ID
     */
    public function setSubscription($id)
    {
        $this->update(['subscription_id' => $id,]);
    }

    /**
     * Suspend Site
     */
    public function suspend()
    {
        $this->update(['suspend_at' => date('Y-m-d H:i:s')]);
    }

    /**
     * Unsuspend Site
     */
    public function unsuspend()
    {
        $this->update(['suspend_at' => null, 'deleted_at' => null]);
    }

    /**
     * Update Site
     */
    public function updatedSite()
    {
        $this->update(['update_at' => date('Y-m-d H:i:s')]);
    }

    /**
     * @return mixed|void
     * Terminate Site
     */
    public function terminate()
    {
        $this->update(['deletedCwp' => date('Y-m-d H:i:s')]);
    }

}
