<?php namespace Visiosoft\SiteModule\Site\AddAddonForm;

use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\SiteModule\Addon\Contract\AddonRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\AddAddonSite;


class AddAddonFormHandler
{
    public function handle(
        AddAddonFormBuilder $builder,
        SiteRepositoryInterface $site,
        CustomFieldRepositoryInterface $cf,
        MessageBag $message,
        AddonRepositoryInterface $addon
    )
    {

        if (!$builder->canSave()) {
            return;
        }

        $parameters = $builder->getPostData();


        if ($site = $site->find($parameters['subdomain'])) {
            foreach ($parameters['addon'] as $item) {
                if ($is_addon = $cf->getAdValueByCustomFieldSlug('addon_composer_name', $item)) {
                    event(new AddAddonSite($site, $is_addon));

                    $addon->create([
                        'subdomain' => $site,
                        'addon' => $is_addon,
                        'payment' => false,
                        'installed' => 'pending',
                        'entry_id' => $item,
                        'entry_type' => 'Visiosoft\AdvsModule\Adv\AdvModel'
                    ]);

                    $message->success(trans('visiosoft.module.site::message.addAddon'));
                } else {
                    $message->error(trans('visiosoft.module.site::message.error_addon_slug'));
                }
            }
        }
    }
}
