<?php namespace Visiosoft\SiteModule\Site\Table\Handler;

use Anomaly\Streams\Platform\Ui\Table\Component\Action\ActionHandler;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;

class Update extends ActionHandler
{
    public function handle(SiteRepositoryInterface $siteRepository, array $selected)
    {
        foreach ($selected as $id) {
            if ($site = $siteRepository->find($id)) {
                \Visiosoft\SiteModule\Site\Jobs\UpdateSite::dispatch($site);
            }
        }

        if ($selected) {
            $this->messages->success(trans('visiosoft.module.site::message.updated', ['count' => count($selected)]));
        }
    }
}