<?php namespace Visiosoft\SiteModule\Addon\Table\Handler;

use Anomaly\Streams\Platform\Ui\Table\Component\Action\ActionHandler;
use Visiosoft\SiteModule\Addon\Contract\AddonRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\DeleteAddonSite;

class Delete extends ActionHandler
{
    public function handle(AddonRepositoryInterface $addon, array $selected)
    {
        try {
            foreach ($selected as $id) {
                if ($addon = $addon->find($id)) {

                    event(new DeleteAddonSite($addon));
                    $addon->update(['deleted_at' => date('Y-m-d H:i:s')]);

                    $this->messages->success(trans('visiosoft.module.site::message.deleted', ['name' => $addon->addon]));
                }
            }
        } catch (\Exception $exception) {
            $this->messages->error([trans('visiosoft.module.site::message.error_server')]);
        }
    }
}