<?php namespace Visiosoft\SiteModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\SiteModule\Bundle\Contract\BundleRepositoryInterface;
use Visiosoft\SiteModule\Site\Contract\SiteRepositoryInterface;

class BundlesController extends ResourceController
{
    protected $repository;
    protected $siteRepository;

    public function __construct(BundleRepositoryInterface $repository, SiteRepositoryInterface $siteRepository)
    {
        $this->repository = $repository;
        $this->siteRepository = $siteRepository;
        parent::__construct();
    }

    public function detail($id)
    {
        if ($bundle = $this->repository->find($id)) {
            return $this->view->make('visiosoft.module.site::bundle/detail', compact('bundle'));
        }
        abort(404);
    }

    public function addCart()
    {
        //Check Cart Params
        if (!$this->request->has(['bundle', 'site'])) {
            abort(403);
        }

        if(!$bundle = $this->repository->find($this->request->get('bundle')))
        {
            abort(403);
        }

        //Check Site and Completed Installation
        if (!$site = $this->siteRepository->find($this->request->get('site')) or $site->status != "completed") {
            abort(403);
        }

        $cart = $this->dispatch(new GetCart());
        $bundle->currency = setting_value('streams::currency');
        $bundle->related = $site;
        $cart->add($bundle, 1, $site->getUrl());
        return redirect('cart');
    }
}
